/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.expression.function;

import io.streamthoughts.kafka.connect.filepulse.expression.Expression;
import io.streamthoughts.kafka.connect.filepulse.expression.function.Argument;
import io.streamthoughts.kafka.connect.filepulse.expression.function.ExpressionArgument;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Arguments
implements Iterable<Argument> {
    private final List<Argument> arguments;

    public static Arguments of(Argument ... arguments) {
        return new Arguments(Arrays.asList(arguments));
    }

    public static Arguments of(String name1, Expression expression1) {
        return Arguments.of(new ExpressionArgument(name1, expression1));
    }

    public static Arguments of(String name1, Expression expression1, String name2, Expression expression2) {
        return Arguments.of(new ExpressionArgument(name1, expression1), new ExpressionArgument(name2, expression2));
    }

    public static Arguments of(String name1, Expression expression1, String name2, Expression expression2, String name3, Expression expression3) {
        return Arguments.of(new ExpressionArgument(name1, expression1), new ExpressionArgument(name2, expression2), new ExpressionArgument(name3, expression3));
    }

    public static Arguments empty() {
        return new Arguments(){

            @Override
            public Iterator<Argument> iterator() {
                return Collections.emptyIterator();
            }

            @Override
            public String toString() {
                return "[]";
            }
        };
    }

    public Arguments() {
        this(new LinkedList<Argument>());
    }

    public Arguments(Argument argument) {
        this(Collections.singletonList(argument));
    }

    public Arguments(List<Argument> arguments) {
        this.arguments = arguments;
    }

    private Arguments add(Argument argument) {
        this.arguments.add(argument);
        return this;
    }

    public Argument get(int index) {
        return this.arguments.get(index);
    }

    public List<Argument> get(int index, int to) {
        return this.arguments.subList(index, to);
    }

    public int size() {
        return this.arguments.size();
    }

    public <V> Optional<V> valueOf(String name) {
        Objects.requireNonNull(name, "name cannot be null");
        Optional<Object> value = this.arguments.stream().filter(a -> a.name().equals(name)).findFirst().map(Argument::value);
        return value;
    }

    @Override
    public Iterator<Argument> iterator() {
        return this.arguments.iterator();
    }

    public String toString() {
        return this.arguments.toString();
    }
}

