/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.expression.function;

import io.streamthoughts.kafka.connect.filepulse.data.TypedValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class EvaluatedExecutionContext {
    private final Map<Integer, TypedValue> argumentByIndex;
    private final Map<String, TypedValue> argumentByName = new HashMap<String, TypedValue>();

    EvaluatedExecutionContext() {
        this.argumentByIndex = new HashMap<Integer, TypedValue>();
    }

    void addArgument(String name, int index, TypedValue value) {
        this.argumentByName.put(name, value);
        this.argumentByIndex.put(index, value);
    }

    public TypedValue get(int index) {
        if (!this.argumentByIndex.containsKey(index)) {
            throw new IndexOutOfBoundsException(index);
        }
        return Optional.ofNullable(this.argumentByIndex.get(index)).orElse(TypedValue.none());
    }

    public TypedValue get(String name) {
        return Optional.ofNullable(this.argumentByName.get(name)).orElse(TypedValue.none());
    }

    public List<TypedValue> get(int index, int to) {
        return this.values().subList(index, to);
    }

    public int size() {
        return this.argumentByName.size();
    }

    public List<TypedValue> values() {
        return new ArrayList<TypedValue>(this.argumentByIndex.values());
    }
}

