/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.expression.function;

import io.streamthoughts.kafka.connect.filepulse.data.TypedValue;
import io.streamthoughts.kafka.connect.filepulse.expression.EvaluationContext;
import io.streamthoughts.kafka.connect.filepulse.expression.Expression;
import io.streamthoughts.kafka.connect.filepulse.expression.ExpressionException;
import io.streamthoughts.kafka.connect.filepulse.expression.function.Argument;
import io.streamthoughts.kafka.connect.filepulse.expression.function.Arguments;
import io.streamthoughts.kafka.connect.filepulse.expression.function.ExpressionArgument;
import java.util.ArrayList;
import java.util.function.Supplier;

public interface ExpressionFunction
extends Supplier<Instance> {
    default public String name() {
        return ExpressionFunction.functionNameFor(this);
    }

    @Override
    public Instance get();

    public static String functionNameFor(ExpressionFunction function) {
        StringBuilder b = new StringBuilder();
        String className = function.getClass().getSimpleName();
        boolean firstChar = true;
        for (char c : className.toCharArray()) {
            if (c >= 'A' && c <= 'Z') {
                if (!firstChar) {
                    b.append("_");
                }
                b.append(c);
            } else if (c >= 'a' && c <= 'z' || c >= '0' && c <= '9') {
                b.append(c);
            } else if (c >= ' ') {
                b.append("_");
            }
            firstChar = false;
        }
        return b.toString().toLowerCase();
    }

    @FunctionalInterface
    public static interface Instance {
        default public Arguments prepare(Expression[] args) throws ExpressionException {
            if (args.length == 0) {
                return Arguments.empty();
            }
            ArrayList<Argument> arguments = new ArrayList<Argument>();
            for (int i = 0; i < args.length; ++i) {
                arguments.add(new ExpressionArgument(String.valueOf(i), args[i]));
            }
            return new Arguments(arguments);
        }

        public TypedValue invoke(EvaluationContext var1, Arguments var2) throws ExpressionException;
    }
}

