/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.expression.function;

import io.streamthoughts.kafka.connect.filepulse.data.TypedValue;
import io.streamthoughts.kafka.connect.filepulse.expression.EvaluationContext;
import io.streamthoughts.kafka.connect.filepulse.expression.function.Arguments;
import io.streamthoughts.kafka.connect.filepulse.expression.function.ExpressionFunction;
import java.util.Objects;

public class ExpressionFunctionExecutor {
    private final String name;
    private final ExpressionFunction.Instance instance;
    private final Arguments arguments;

    ExpressionFunctionExecutor(String name, ExpressionFunction.Instance instance, Arguments arguments) {
        this.name = Objects.requireNonNull(name, "name cannot be null");
        this.instance = Objects.requireNonNull(instance, "instance cannot be null");
        this.arguments = Objects.requireNonNull(arguments, "arguments cannot be null");
    }

    public TypedValue execute(EvaluationContext context) {
        return this.instance.invoke(context, this.arguments);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExpressionFunctionExecutor)) {
            return false;
        }
        ExpressionFunctionExecutor that = (ExpressionFunctionExecutor)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.instance, that.instance) && Objects.equals(this.arguments, that.arguments);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.arguments);
    }

    public String toString() {
        return "[name='" + this.name + "', arguments=" + String.valueOf(this.arguments) + "]";
    }
}

