/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.expression.function.conditions;

import io.streamthoughts.kafka.connect.filepulse.data.TypedValue;
import io.streamthoughts.kafka.connect.filepulse.expression.Expression;
import io.streamthoughts.kafka.connect.filepulse.expression.ExpressionException;
import io.streamthoughts.kafka.connect.filepulse.expression.function.AbstractExpressionFunctionInstance;
import io.streamthoughts.kafka.connect.filepulse.expression.function.Arguments;
import io.streamthoughts.kafka.connect.filepulse.expression.function.EvaluatedExecutionContext;
import io.streamthoughts.kafka.connect.filepulse.expression.function.ExpressionFunction;

public class If
implements ExpressionFunction {
    private static final String BOOLEAN_EXPRESSION_ARG = "booleanExpression";
    private static final String VALUE_IF_TRUE_ARG = "valueIfTrue";
    private static final String VALUE_IF_FALSE_ARG = "valueIfFalse";

    @Override
    public ExpressionFunction.Instance get() {
        return new AbstractExpressionFunctionInstance(){

            private String syntax() {
                return String.format("syntax %s(<%s>, <%s>, <%s>)", If.this.name(), If.BOOLEAN_EXPRESSION_ARG, If.VALUE_IF_TRUE_ARG, If.VALUE_IF_FALSE_ARG);
            }

            @Override
            public Arguments prepare(Expression[] args) {
                if (args.length < 3) {
                    throw new ExpressionException("Missing required arguments: " + this.syntax());
                }
                return Arguments.of(If.BOOLEAN_EXPRESSION_ARG, args[0], If.VALUE_IF_TRUE_ARG, args[1], If.VALUE_IF_FALSE_ARG, args[2]);
            }

            @Override
            public TypedValue invoke(EvaluatedExecutionContext ctx) throws ExpressionException {
                TypedValue condition = ctx.get(If.BOOLEAN_EXPRESSION_ARG);
                return condition.getBool() != false ? ctx.get(If.VALUE_IF_TRUE_ARG) : ctx.get(If.VALUE_IF_FALSE_ARG);
            }
        };
    }
}

