/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.expression.function.datetime;

import io.streamthoughts.kafka.connect.filepulse.annotation.VisibleForTesting;
import io.streamthoughts.kafka.connect.filepulse.data.TypedValue;
import io.streamthoughts.kafka.connect.filepulse.expression.Expression;
import io.streamthoughts.kafka.connect.filepulse.expression.ExpressionException;
import io.streamthoughts.kafka.connect.filepulse.expression.ValueExpression;
import io.streamthoughts.kafka.connect.filepulse.expression.function.AbstractExpressionFunctionInstance;
import io.streamthoughts.kafka.connect.filepulse.expression.function.Arguments;
import io.streamthoughts.kafka.connect.filepulse.expression.function.EvaluatedExecutionContext;
import io.streamthoughts.kafka.connect.filepulse.expression.function.ExpressionFunction;
import java.time.Instant;
import java.time.temporal.ChronoUnit;

public class TimestampDiff
implements ExpressionFunction {
    @Override
    public ExpressionFunction.Instance get() {
        return new TimestampDiffInstance();
    }

    public static class TimestampDiffInstance
    extends AbstractExpressionFunctionInstance {
        private static final String CHRONO_UNIT_ARG = "unit";
        private static final String EPOCH_MILLI_1_ARG = "epoch_millis_expr1";
        private static final String EPOCH_MILLI_2_ARG = "epoch_millis_expr2";
        private ChronoUnit chronoUnit;

        @Override
        public Arguments prepare(Expression[] args) throws ExpressionException {
            String unit = ((ValueExpression)args[0]).value().getString();
            this.chronoUnit = ChronoUnit.valueOf(unit.toUpperCase());
            return Arguments.of(CHRONO_UNIT_ARG, args[0], EPOCH_MILLI_1_ARG, args[1], EPOCH_MILLI_2_ARG, args[2]);
        }

        @Override
        public TypedValue invoke(EvaluatedExecutionContext context) throws ExpressionException {
            Long epochTimeLeft = context.get(1).getLong();
            Long epochTimeRight = context.get(2).getLong();
            long between = Math.abs(this.chronoUnit.between(TimestampDiffInstance.toInstant(epochTimeLeft), TimestampDiffInstance.toInstant(epochTimeRight)));
            if (!(this.chronoUnit != ChronoUnit.MILLIS || TimestampDiffInstance.isEpochTimeInMillis(epochTimeLeft) && TimestampDiffInstance.isEpochTimeInMillis(epochTimeRight))) {
                between = between < 1000L ? 0L : between / 1000L * 1000L;
            }
            return TypedValue.int64((Long)between);
        }

        @VisibleForTesting
        static Instant toInstant(long epochTime) {
            if (TimestampDiffInstance.isEpochTimeInMillis(epochTime)) {
                return Instant.ofEpochMilli(epochTime);
            }
            return Instant.ofEpochSecond(epochTime);
        }

        private static boolean isEpochTimeInMillis(long epochTime) {
            return String.valueOf(epochTime).length() > 11;
        }
    }
}

