/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.expression.function.datetime;

import io.streamthoughts.kafka.connect.filepulse.data.TypedValue;
import io.streamthoughts.kafka.connect.filepulse.expression.Expression;
import io.streamthoughts.kafka.connect.filepulse.expression.ExpressionException;
import io.streamthoughts.kafka.connect.filepulse.expression.ValueExpression;
import io.streamthoughts.kafka.connect.filepulse.expression.function.AbstractExpressionFunctionInstance;
import io.streamthoughts.kafka.connect.filepulse.expression.function.Arguments;
import io.streamthoughts.kafka.connect.filepulse.expression.function.EvaluatedExecutionContext;
import io.streamthoughts.kafka.connect.filepulse.expression.function.ExpressionFunction;
import io.streamthoughts.kafka.connect.filepulse.internal.DateTimeParser;
import java.time.ZoneId;
import java.time.ZonedDateTime;

public class ToTimestamp
implements ExpressionFunction {
    @Override
    public ExpressionFunction.Instance get() {
        return new AbstractExpressionFunctionInstance(){
            private DateTimeParser parser;
            private ZoneId zoneId = ZoneId.systemDefault();

            private String syntax() {
                return String.format("syntax %s(<datetime_expr>, <pattern> [, timezone]", ToTimestamp.this.name());
            }

            @Override
            public Arguments prepare(Expression[] args) {
                if (args.length > 3) {
                    throw new ExpressionException("Too many arguments: " + this.syntax());
                }
                if (args.length < 2) {
                    throw new ExpressionException("Missing required arguments: " + this.syntax());
                }
                if (args.length == 3) {
                    this.zoneId = ZoneId.of(((ValueExpression)args[2]).value().getString());
                }
                this.parser = new DateTimeParser(((ValueExpression)args[1]).value().getString());
                return Arguments.of("datetime", args[0]);
            }

            @Override
            public TypedValue invoke(EvaluatedExecutionContext context) throws ExpressionException {
                String datetime = context.get(0).getString();
                ZonedDateTime zdt = this.parser.parse(datetime, this.zoneId);
                return TypedValue.int64((Long)zdt.toInstant().toEpochMilli());
            }
        };
    }
}

