/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.expression.function.objects;

import io.streamthoughts.kafka.connect.filepulse.data.Type;
import io.streamthoughts.kafka.connect.filepulse.data.TypedValue;
import io.streamthoughts.kafka.connect.filepulse.expression.Expression;
import io.streamthoughts.kafka.connect.filepulse.expression.ExpressionException;
import io.streamthoughts.kafka.connect.filepulse.expression.ValueExpression;
import io.streamthoughts.kafka.connect.filepulse.expression.function.AbstractExpressionFunctionInstance;
import io.streamthoughts.kafka.connect.filepulse.expression.function.Arguments;
import io.streamthoughts.kafka.connect.filepulse.expression.function.EvaluatedExecutionContext;
import io.streamthoughts.kafka.connect.filepulse.expression.function.ExpressionFunction;
import java.util.Objects;

public class ExtractStructField
implements ExpressionFunction {
    @Override
    public ExpressionFunction.Instance get() {
        return new FunctionInstance(this.syntax());
    }

    private String syntax() {
        return String.format("syntax %s(<struct_expr>, <path>", this.name());
    }

    public static final class FunctionInstance
    extends AbstractExpressionFunctionInstance {
        public static final int EXPECTED_NUM_ARGS = 2;
        private final String syntax;
        private String path;

        public FunctionInstance(String syntax) {
            this.syntax = Objects.requireNonNull(syntax, "'syntax' cannot be null");
        }

        @Override
        public Arguments prepare(Expression[] args) {
            if (args.length > 2) {
                throw new ExpressionException("Too many arguments: " + this.syntax);
            }
            if (args.length < 2) {
                throw new ExpressionException("Missing required arguments: " + this.syntax);
            }
            this.path = ((ValueExpression)args[1]).value().getString();
            return Arguments.of("struct", args[0]);
        }

        @Override
        public TypedValue invoke(EvaluatedExecutionContext context) throws ExpressionException {
            TypedValue value = context.get(0);
            if (value.isNull()) {
                return TypedValue.none();
            }
            if (value.type() != Type.STRUCT) {
                throw new ExpressionException("Expected type STRUCT, was " + String.valueOf(value.type()));
            }
            return value.getStruct().find(this.path);
        }
    }
}

