/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.expression.function.strings;

import io.streamthoughts.kafka.connect.filepulse.data.TypedValue;
import io.streamthoughts.kafka.connect.filepulse.expression.Expression;
import io.streamthoughts.kafka.connect.filepulse.expression.ExpressionException;
import io.streamthoughts.kafka.connect.filepulse.expression.function.AbstractExpressionFunctionInstance;
import io.streamthoughts.kafka.connect.filepulse.expression.function.Arguments;
import io.streamthoughts.kafka.connect.filepulse.expression.function.EvaluatedExecutionContext;
import io.streamthoughts.kafka.connect.filepulse.expression.function.ExpressionFunction;

public class EndsWith
implements ExpressionFunction {
    private static final String FIELD_ARG = "field_expr";
    private static final String SUFFIX_ARG = "suffix";

    @Override
    public ExpressionFunction.Instance get() {
        return new AbstractExpressionFunctionInstance(){

            private String syntax() {
                return String.format("syntax %s(<%s>, <%s>)", EndsWith.this.name(), EndsWith.FIELD_ARG, EndsWith.SUFFIX_ARG);
            }

            @Override
            public Arguments prepare(Expression[] args) {
                if (args.length > 2) {
                    throw new ExpressionException("Too many arguments: " + this.syntax());
                }
                if (args.length < 2) {
                    throw new ExpressionException("Missing required arguments: " + this.syntax());
                }
                return Arguments.of(EndsWith.FIELD_ARG, args[0], EndsWith.SUFFIX_ARG, args[1]);
            }

            @Override
            public TypedValue invoke(EvaluatedExecutionContext context) throws ExpressionException {
                TypedValue string = context.get(EndsWith.FIELD_ARG);
                TypedValue prefix = context.get(EndsWith.SUFFIX_ARG);
                return TypedValue.bool((Boolean)string.getString().endsWith(prefix.getString()));
            }
        };
    }
}

