/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.expression.function.strings;

import io.streamthoughts.kafka.connect.filepulse.data.TypedStruct;
import io.streamthoughts.kafka.connect.filepulse.data.TypedValue;
import io.streamthoughts.kafka.connect.filepulse.expression.Expression;
import io.streamthoughts.kafka.connect.filepulse.expression.ExpressionException;
import io.streamthoughts.kafka.connect.filepulse.expression.ValueExpression;
import io.streamthoughts.kafka.connect.filepulse.expression.function.AbstractExpressionFunctionInstance;
import io.streamthoughts.kafka.connect.filepulse.expression.function.Arguments;
import io.streamthoughts.kafka.connect.filepulse.expression.function.EvaluatedExecutionContext;
import io.streamthoughts.kafka.connect.filepulse.expression.function.ExpressionFunction;
import io.streamthoughts.kafka.connect.filepulse.internal.StringUtils;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParseUrl
implements ExpressionFunction {
    private static final String FIELD_ARG = "field_expr";
    private static final String PERMISSIVE_ARG = "permissive";
    private static final Logger LOG = LoggerFactory.getLogger(ParseUrl.class);
    private static final Pattern QUERY_PATTERN = Pattern.compile("([^&=]+)(=?)([^&]+)?");
    public static final String FRAGMENT_FIELD = "fragment";
    public static final String HOST_FIELD = "host";
    public static final String PATH_FIELD = "path";
    public static final String PORT_FIELD = "port";
    public static final String QUERY_FIELD = "query";
    public static final String SCHEME_FIELD = "scheme";
    public static final String USER_INFO_FIELD = "userInfo";
    public static final String ERROR_FIELD = "error";
    public static final String PARAMETERS_FIELD = "parameters";

    @Override
    public ExpressionFunction.Instance get() {
        return new Instance(this.name());
    }

    static class Instance
    extends AbstractExpressionFunctionInstance {
        private final String name;
        private boolean permissive;

        public Instance(String name) {
            this.name = Objects.requireNonNull(name, "'name' should not be null");
        }

        private String syntax() {
            return String.format("syntax %s(<%s>, [<%s>])", this.name, ParseUrl.FIELD_ARG, ParseUrl.PERMISSIVE_ARG);
        }

        @Override
        public Arguments prepare(Expression[] args) {
            if (args.length > 2) {
                throw new ExpressionException("Too many arguments: " + this.syntax());
            }
            if (args.length < 1) {
                throw new ExpressionException("Missing required arguments: " + this.syntax());
            }
            this.permissive = args.length == 2 ? ((ValueExpression)args[1]).value().getBool() : false;
            return Arguments.of(ParseUrl.FIELD_ARG, args[0]);
        }

        @Override
        public TypedValue invoke(EvaluatedExecutionContext context) throws ExpressionException {
            String stringValue = (String)context.get(0).value();
            try {
                URI uri = URI.create(stringValue);
                if (uri.getScheme() == null) {
                    return this.rethrowOrGetPermissiveResult(stringValue, "Could not parse URL: scheme not specified");
                }
                return TypedValue.struct((TypedStruct)TypedStruct.create().put(ParseUrl.FRAGMENT_FIELD, uri.getFragment()).put(ParseUrl.HOST_FIELD, uri.getHost()).put(ParseUrl.USER_INFO_FIELD, uri.getUserInfo()).put(ParseUrl.PATH_FIELD, Instance.getPath(uri)).put(ParseUrl.PORT_FIELD, uri.getPort() == -1 ? null : Integer.valueOf(uri.getPort())).put(ParseUrl.QUERY_FIELD, uri.getQuery()).put(ParseUrl.SCHEME_FIELD, uri.getScheme()).put(ParseUrl.PARAMETERS_FIELD, this.parseQueryParams(uri.getRawQuery())));
            }
            catch (IllegalArgumentException e) {
                return this.rethrowOrGetPermissiveResult(stringValue, e.getLocalizedMessage());
            }
        }

        private static String getPath(URI uri) {
            return Optional.ofNullable(uri.getPath()).orElse(uri.getSchemeSpecificPart());
        }

        private TypedValue rethrowOrGetPermissiveResult(String stringValue, String errorMessage) {
            if (!this.permissive) {
                throw new ExpressionException(errorMessage);
            }
            LOG.warn("Error parsing URL from value {}. Error:  {}", (Object)stringValue, (Object)errorMessage);
            return TypedValue.struct((TypedStruct)TypedStruct.create().put(ParseUrl.ERROR_FIELD, errorMessage));
        }

        protected Map<String, List<String>> parseQueryParams(String query) {
            LinkedHashMap<String, List> queryParams = null;
            if (query != null) {
                queryParams = new LinkedHashMap<String, List>();
                Matcher matcher = QUERY_PATTERN.matcher(query);
                while (matcher.find()) {
                    String name = this.decodeQueryParam(matcher.group(1));
                    String eq = matcher.group(2);
                    String value = matcher.group(3);
                    value = value != null ? this.decodeQueryParam(value) : (StringUtils.isNotBlank((String)eq) ? "" : null);
                    queryParams.computeIfAbsent(name, k -> new LinkedList()).add(value);
                }
            }
            return queryParams;
        }

        private String decodeQueryParam(String value) {
            return URLDecoder.decode(value, StandardCharsets.UTF_8);
        }
    }
}

