/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.expression.function.strings;

import io.streamthoughts.kafka.connect.filepulse.data.TypedValue;
import io.streamthoughts.kafka.connect.filepulse.expression.Expression;
import io.streamthoughts.kafka.connect.filepulse.expression.ExpressionException;
import io.streamthoughts.kafka.connect.filepulse.expression.ValueExpression;
import io.streamthoughts.kafka.connect.filepulse.expression.function.AbstractExpressionFunctionInstance;
import io.streamthoughts.kafka.connect.filepulse.expression.function.Arguments;
import io.streamthoughts.kafka.connect.filepulse.expression.function.EvaluatedExecutionContext;
import io.streamthoughts.kafka.connect.filepulse.expression.function.ExpressionFunction;
import java.util.Objects;
import java.util.regex.Pattern;

public class ReplaceAll
implements ExpressionFunction {
    private static final String FIELD_ARG = "field_expr";
    private static final String PATTERN_ARG = "pattern";
    private static final String REPLACEMENT_ARG = "replacement";

    @Override
    public ExpressionFunction.Instance get() {
        return new Instance(this.name());
    }

    static class Instance
    extends AbstractExpressionFunctionInstance {
        private Pattern pattern;
        private final String name;

        public Instance(String name) {
            this.name = Objects.requireNonNull(name, "'name' should not be null");
        }

        private String syntax() {
            return String.format("syntax %s(<%s>, <%s>, <%s>)", this.name, ReplaceAll.FIELD_ARG, ReplaceAll.PATTERN_ARG, ReplaceAll.REPLACEMENT_ARG);
        }

        @Override
        public Arguments prepare(Expression[] args) {
            if (args.length > 3) {
                throw new ExpressionException("Too many arguments: " + this.syntax());
            }
            if (args.length < 3) {
                throw new ExpressionException("Missing required arguments: " + this.syntax());
            }
            this.pattern = Pattern.compile(((ValueExpression)args[1]).value().getString());
            return Arguments.of(ReplaceAll.FIELD_ARG, args[0], ReplaceAll.PATTERN_ARG, args[1], ReplaceAll.REPLACEMENT_ARG, args[2]);
        }

        @Override
        public TypedValue invoke(EvaluatedExecutionContext context) throws ExpressionException {
            TypedValue replacement = context.get(ReplaceAll.REPLACEMENT_ARG);
            TypedValue value = context.get(ReplaceAll.FIELD_ARG);
            String matched = this.pattern.matcher(value.getString()).replaceAll(replacement.getString());
            return TypedValue.string((String)matched);
        }
    }
}

