/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.transform;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

public class GrokConfig
extends AbstractConfig {
    public static final String GROK_PATTERN_CONFIG = "pattern";
    private static final String GROK_PATTERN_DOC = "The Grok pattern to matches.";
    public static final String GROK_PATTERNS_PREFIX_CONFIG = "patterns.";
    public static final String GROK_PATTERN_DEFINITIONS_CONFIG = "patternDefinitions";
    private static final String GROK_PATTERN_DEFINITIONS_DOC = "Custom pattern definitions";
    public static final String GROK_PATTERNS_DIR_CONFIG = "patternsDir";
    private static final String GROK_PATTERNS_DIR_DOC = "List of user-defined pattern directories";
    public static final String GROK_NAMED_CAPTURES_ONLY_CONFIG = "namedCapturesOnly";
    private static final String GROK_NAMED_CAPTURES_ONLY_DOC = "If true, only store named captures from grok (default=true).";
    private static final boolean GROK_NAMED_CAPTURES_ONLY_DEFAULT = true;
    public static final String GROK_PATTERN_BREAK_ON_FIRST_PATTERN = "breakOnFirstPattern";
    private static final String GROK_PATTERN_BREAK_ON_FIRST_DOC = "If true, break on the first successful matching. Otherwise, the transformation will try all configured grok patterns";
    private static final boolean GROK_PATTERN_BREAK_ON_FIRST_DEFAULT = true;

    public GrokConfig(Map<String, ?> originals) {
        super(GrokConfig.configDef(), originals);
    }

    public boolean breakOnFirstPattern() {
        return this.getBoolean(GROK_PATTERN_BREAK_ON_FIRST_PATTERN);
    }

    public List<String> patterns() {
        String pattern = this.getString(GROK_PATTERN_CONFIG);
        if (pattern != null) {
            return List.of(pattern);
        }
        List<String> patterns = this.getOrderedSubProperties(GROK_PATTERNS_PREFIX_CONFIG);
        if (patterns.isEmpty()) {
            throw new ConfigException("Missing required configuration, either pattern or patterns option must be configured");
        }
        return patterns;
    }

    private List<String> getOrderedSubProperties(String prefix) {
        return this.originalsWithPrefix(prefix).entrySet().stream().sorted(Comparator.comparingInt(o -> Integer.parseInt((String)o.getKey()))).map(Map.Entry::getValue).map(Object::toString).collect(Collectors.toList());
    }

    public List<String> patternDefinitions() {
        return this.getList(GROK_PATTERN_DEFINITIONS_CONFIG);
    }

    public boolean namedCapturesOnly() {
        return this.getBoolean(GROK_NAMED_CAPTURES_ONLY_CONFIG);
    }

    public Collection<File> patternsDir() {
        return this.getList(GROK_PATTERNS_DIR_CONFIG).stream().map(File::new).collect(Collectors.toList());
    }

    public static ConfigDef configDef() {
        return new ConfigDef().define(GROK_PATTERN_CONFIG, ConfigDef.Type.STRING, null, ConfigDef.Importance.HIGH, GROK_PATTERN_DOC).define(GROK_NAMED_CAPTURES_ONLY_CONFIG, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.MEDIUM, GROK_NAMED_CAPTURES_ONLY_DOC).define(GROK_PATTERNS_DIR_CONFIG, ConfigDef.Type.LIST, Collections.emptyList(), ConfigDef.Importance.MEDIUM, GROK_PATTERNS_DIR_DOC).define(GROK_PATTERN_DEFINITIONS_CONFIG, ConfigDef.Type.LIST, Collections.emptyList(), ConfigDef.Importance.MEDIUM, GROK_PATTERN_DEFINITIONS_DOC).define(GROK_PATTERN_BREAK_ON_FIRST_PATTERN, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.MEDIUM, GROK_PATTERN_BREAK_ON_FIRST_DOC);
    }
}

