/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.transform.data.internal;

import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import org.apache.kafka.connect.errors.DataException;

public class TypeConverter
implements Serializable {
    public static Collection getArray(Object value) throws IllegalArgumentException {
        Objects.requireNonNull(value, "value can't be null");
        if (Collection.class.isAssignableFrom(value.getClass())) {
            return (Collection)value;
        }
        if (value instanceof Object[]) {
            return Arrays.asList((Object[])value);
        }
        throw new DataException(String.format("'%s' is not assignable to Collection \"%s\"", value.getClass(), value));
    }

    public static Boolean getBool(Object value) throws IllegalArgumentException {
        Boolean result = null;
        if (value == null) {
            result = false;
        }
        if (value instanceof String) {
            char digit;
            String s = (String)value;
            result = s.length() == 1 && Character.isDigit(s.charAt(0)) ? Boolean.valueOf((digit = s.charAt(0)) > '\u0000') : Boolean.valueOf(s.equalsIgnoreCase("true") || s.equalsIgnoreCase("yes") || s.equalsIgnoreCase("y"));
        }
        if (value instanceof Boolean) {
            result = (Boolean)value;
        }
        if (result == null) {
            throw new DataException(String.format("Cannot parse boolean content from \"%s\"", value));
        }
        return result;
    }

    public static Short getShort(Object value) throws IllegalArgumentException {
        Objects.requireNonNull(value, "value can't be null");
        if (value instanceof String && TypeConverter.isNumber((String)value)) {
            return new BigDecimal(value.toString()).shortValue();
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.shortValue();
        }
        throw new DataException(String.format("Cannot parse 32-bits int content from \"%s\"", value));
    }

    public static Integer getInt(Object value) throws IllegalArgumentException {
        Objects.requireNonNull(value, "value can't be null");
        if (value instanceof String && TypeConverter.isNumber((String)value)) {
            return new BigDecimal(value.toString()).intValue();
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.intValue();
        }
        throw new DataException(String.format("Cannot parse 32-bits int content from \"%s\"", value));
    }

    public static Long getLong(Object value) throws IllegalArgumentException {
        Objects.requireNonNull(value, "value can't be null");
        if (value instanceof String && TypeConverter.isNumber((String)value)) {
            return new BigDecimal(value.toString()).longValue();
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.longValue();
        }
        throw new DataException(String.format("Cannot parse 64-bits long content from \"%s\"", value));
    }

    public static Float getFloat(Object value) throws IllegalArgumentException {
        Objects.requireNonNull(value, "value can't be null");
        if (value instanceof String && TypeConverter.isNumber((String)value)) {
            return Float.valueOf(new BigDecimal(value.toString()).floatValue());
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return Float.valueOf(number.floatValue());
        }
        throw new DataException(String.format("Cannot parse 32-bits float content from \"%s\"", value));
    }

    public static Double getDouble(Object value) throws IllegalArgumentException {
        Objects.requireNonNull(value, "value can't be null");
        if (value instanceof String && TypeConverter.isNumber((String)value)) {
            return new BigDecimal(value.toString()).doubleValue();
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.doubleValue();
        }
        throw new DataException(String.format("Cannot parse 64-bits double content from \"%s\"", value));
    }

    public static Date getDate(Object value) throws IllegalArgumentException {
        Objects.requireNonNull(value, "value can't be null");
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return new Date(number.longValue());
        }
        if (value instanceof String && TypeConverter.isNumber((String)value)) {
            return new Date(Long.parseLong((String)value));
        }
        throw new DataException(String.format("Cannot parse Date content from \"%s\"", value));
    }

    public static String getString(Object value) {
        if (value instanceof ByteBuffer) {
            return StandardCharsets.UTF_8.decode((ByteBuffer)value).toString();
        }
        return value != null ? value.toString() : null;
    }

    public static byte[] getBytes(Object value) {
        if (value instanceof ByteBuffer) {
            return ((ByteBuffer)value).array();
        }
        if (value instanceof String) {
            return ((String)value).getBytes(StandardCharsets.UTF_8);
        }
        if (value.getClass().isArray()) {
            return (byte[])value;
        }
        throw new DataException(String.format("Cannot parse byte[] from \"%s\"", value));
    }

    public static BigDecimal getDecimal(Object value) {
        Objects.requireNonNull(value, "value can't be null");
        String result = null;
        if (value instanceof Double) {
            result = String.valueOf(value);
        }
        if (value instanceof Integer) {
            result = String.valueOf(value);
        }
        if (value instanceof String) {
            result = (String)value;
        }
        if (result == null) {
            throw new DataException(String.format("Cannot parse decimal content from \"%s\"", value));
        }
        if (result.trim().length() == 0) {
            return null;
        }
        try {
            return new BigDecimal(result.replace(",", "."));
        }
        catch (NumberFormatException e) {
            throw new DataException(String.format("Cannot parse decimal content from \"%s\"", value));
        }
    }

    private static boolean isNumber(String s) {
        if (s.isEmpty()) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (!(i == 0 && s.charAt(i) == '-' ? s.length() == 1 : Character.digit(s.charAt(i), 10) < 0)) continue;
            return false;
        }
        return true;
    }
}

