/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.transform.pattern;

import io.streamthoughts.kafka.connect.transform.data.Type;

public class GrokPattern {
    private final String syntax;
    private final String semantic;
    private final Type type;

    GrokPattern(String syntax, String semantic, String type) {
        this(syntax, semantic, GrokPattern.toType(type));
    }

    GrokPattern(String syntax, String semantic, Type type) {
        this.syntax = syntax;
        this.semantic = semantic;
        this.type = type;
    }

    public String syntax() {
        return this.syntax;
    }

    public String semantic() {
        return this.semantic;
    }

    public Type type() {
        return this.type;
    }

    private static Type toType(String type) {
        return type != null ? Type.forName(type.toUpperCase()) : Type.STRING;
    }

    public String toString() {
        return "GrokPattern{syntax='" + this.syntax + "', semantic='" + this.semantic + "', type='" + this.type + "'}";
    }
}

