/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.generators.examples;

import io.swagger.codegen.v3.generators.util.OpenAPIUtil;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.DateSchema;
import io.swagger.v3.oas.models.media.DateTimeSchema;
import io.swagger.v3.oas.models.media.FileSchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.media.UUIDSchema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExampleGenerator {
    private static final Logger logger = LoggerFactory.getLogger(ExampleGenerator.class);
    private static final String MIME_TYPE_JSON = "application/json";
    private static final String MIME_TYPE_XML = "application/xml";
    private static final String EXAMPLE = "example";
    private static final String CONTENT_TYPE = "contentType";
    private static final String OUTPUT = "output";
    private static final String NONE = "none";
    private static final String URL = "url";
    private static final String URI = "uri";
    protected Map<String, Schema> examples;
    private Random random;
    private OpenAPI openAPI;

    public ExampleGenerator(OpenAPI openAPI) {
        this.openAPI = openAPI;
        this.random = new Random("ExampleGenerator".hashCode());
    }

    public List<Map<String, String>> generateFromSchema(Schema schema, Set<String> producesInfo) {
        return null;
    }

    public List<Map<String, String>> generate(Map<String, Object> examples, List<String> mediaTypes, Schema schema) {
        ArrayList<Map<String, String>> output = new ArrayList<Map<String, String>>();
        HashSet<String> processedModels = new HashSet<String>();
        if (examples == null) {
            if (mediaTypes == null) {
                mediaTypes = Collections.singletonList(MIME_TYPE_JSON);
            }
            if (schema == null) {
                return output;
            }
            for (String string : mediaTypes) {
                HashMap<String, String> kv = new HashMap<String, String>();
                kv.put(CONTENT_TYPE, string);
                if (string.startsWith(MIME_TYPE_JSON)) {
                    String example = Json.pretty((Object)this.resolveSchemaToExample("", string, schema, processedModels));
                    if (example == null) continue;
                    kv.put(EXAMPLE, example);
                    output.add(kv);
                    continue;
                }
                if (!string.startsWith(MIME_TYPE_XML)) continue;
            }
        } else {
            for (Map.Entry entry : examples.entrySet()) {
                HashMap<String, String> kv = new HashMap<String, String>();
                kv.put(CONTENT_TYPE, (String)entry.getKey());
                kv.put(EXAMPLE, Json.pretty(entry.getValue()));
                output.add(kv);
            }
        }
        if (output.size() == 0) {
            HashMap<String, String> kv = new HashMap<String, String>();
            kv.put(OUTPUT, NONE);
            output.add(kv);
        }
        return output;
    }

    public List<Map<String, String>> generate(Map<String, Object> examples, List<String> mediaTypes, String modelName) {
        ArrayList<Map<String, String>> output = new ArrayList<Map<String, String>>();
        HashSet<String> processedModels = new HashSet<String>();
        if (examples == null) {
            if (mediaTypes == null) {
                mediaTypes = Collections.singletonList(MIME_TYPE_JSON);
            }
            for (String string : mediaTypes) {
                HashMap<String, String> kv = new HashMap<String, String>();
                kv.put(CONTENT_TYPE, string);
                if (modelName != null && string.startsWith(MIME_TYPE_JSON)) {
                    String example;
                    Schema schema = this.examples.get(modelName);
                    if (schema == null || (example = Json.pretty((Object)this.resolveModelToExample(modelName, string, schema, processedModels))) == null) continue;
                    kv.put(EXAMPLE, example);
                    output.add(kv);
                    continue;
                }
                if (modelName == null || !string.startsWith(MIME_TYPE_XML)) continue;
                Schema schema = this.examples.get(modelName);
            }
        } else {
            for (Map.Entry entry : examples.entrySet()) {
                HashMap<String, String> kv = new HashMap<String, String>();
                kv.put(CONTENT_TYPE, (String)entry.getKey());
                kv.put(EXAMPLE, Json.pretty(entry.getValue()));
                output.add(kv);
            }
        }
        if (output.size() == 0) {
            HashMap<String, String> kv = new HashMap<String, String>();
            kv.put(OUTPUT, NONE);
            output.add(kv);
        }
        return output;
    }

    private Object resolveSchemaToExample(String propertyName, String mediaType, Schema schema, Set<String> processedModels) {
        if (processedModels.contains(schema.get$ref())) {
            return schema.getExample();
        }
        if (StringUtils.isNotBlank((CharSequence)schema.get$ref())) {
            processedModels.add(schema.get$ref());
        }
        if (schema.getExample() != null) {
            logger.debug("Example set in swagger spec, returning example: '{}'", (Object)schema.getExample().toString());
            return schema.getExample();
        }
        if (schema instanceof StringSchema) {
            logger.debug("String property");
            String defaultValue = (String)((StringSchema)schema).getDefault();
            if (defaultValue != null && !defaultValue.isEmpty()) {
                logger.debug("Default value found: '{}'", (Object)defaultValue);
                return defaultValue;
            }
            List enumValues = ((StringSchema)schema).getEnum();
            if (enumValues != null && !enumValues.isEmpty()) {
                logger.debug("Enum value found: '{}'", enumValues.get(0));
                return enumValues.get(0);
            }
            String format = schema.getFormat();
            if (format != null && (URI.equals(format) || URL.equals(format))) {
                logger.debug("URI or URL format, without default or enum, generating random one.");
                return "http://example.com/aeiou";
            }
            logger.debug("No values found, using property name " + propertyName + " as example");
            return propertyName;
        }
        if (schema instanceof BooleanSchema) {
            Object defaultValue = schema.getDefault();
            if (defaultValue != null) {
                return defaultValue;
            }
            return Boolean.TRUE;
        }
        if (schema instanceof ArraySchema) {
            Schema innerType = ((ArraySchema)schema).getItems();
            if (innerType != null) {
                int arrayLength;
                int n = arrayLength = schema.getMaxItems() != null ? schema.getMaxItems() : 2;
                if (arrayLength > 10) {
                    logger.warn("value of maxItems of property {} is {}; limiting to 10 examples", (Object)schema, (Object)arrayLength);
                    arrayLength = 10;
                }
                Object[] objectProperties = new Object[arrayLength];
                Object objProperty = this.resolveSchemaToExample(propertyName, mediaType, innerType, processedModels);
                for (int i = 0; i < arrayLength; ++i) {
                    objectProperties[i] = objProperty;
                }
                return objectProperties;
            }
        } else {
            if (schema instanceof DateSchema) {
                return "2000-01-23";
            }
            if (schema instanceof DateTimeSchema) {
                return "2000-01-23T04:56:07.000+00:00";
            }
            if (schema instanceof NumberSchema) {
                Double max;
                Double min = schema.getMinimum() == null ? null : Double.valueOf(schema.getMinimum().doubleValue());
                Double d = max = schema.getMaximum() == null ? null : Double.valueOf(schema.getMaximum().doubleValue());
                if ("float".equals(schema.getFormat())) {
                    return Float.valueOf((float)this.randomNumber(min, max));
                }
                return this.randomNumber(min, max);
            }
            if (schema instanceof FileSchema) {
                return "";
            }
            if (schema instanceof IntegerSchema) {
                Double max;
                Double min = schema.getMinimum() == null ? null : Double.valueOf(schema.getMinimum().doubleValue());
                Double d = max = schema.getMaximum() == null ? null : Double.valueOf(schema.getMaximum().doubleValue());
                if ("int32".equals(schema.getFormat())) {
                    return (long)this.randomNumber(min, max);
                }
                return (int)this.randomNumber(min, max);
            }
            if (schema instanceof MapSchema && schema.getAdditionalProperties() != null && schema.getAdditionalProperties() instanceof Schema) {
                HashMap<String, Object> mp = new HashMap<String, Object>();
                if (schema.getName() != null) {
                    mp.put(schema.getName(), this.resolveSchemaToExample(propertyName, mediaType, (Schema)schema.getAdditionalProperties(), processedModels));
                } else {
                    mp.put("key", this.resolveSchemaToExample(propertyName, mediaType, (Schema)schema.getAdditionalProperties(), processedModels));
                }
                return mp;
            }
            if (!StringUtils.isEmpty((CharSequence)schema.get$ref())) {
                String simpleName = OpenAPIUtil.getSimpleRef(schema.get$ref());
                Schema model = null;
                if (this.openAPI != null && this.openAPI.getComponents() != null && this.openAPI.getComponents().getSchemas() != null) {
                    model = (Schema)this.openAPI.getComponents().getSchemas().get(simpleName);
                }
                if (model == null) {
                    return "{}";
                }
                return this.resolveSchemaToExample(propertyName, mediaType, model, processedModels);
            }
            if (schema instanceof ObjectSchema || schema.getProperties() != null) {
                HashMap<String, Object> values = new HashMap<String, Object>();
                if (schema.getProperties() != null) {
                    logger.debug("Creating example from model values");
                    for (Object propName : schema.getProperties().keySet()) {
                        Schema schemaProperty = (Schema)schema.getProperties().get(propName.toString());
                        values.put(propName.toString(), this.resolveSchemaToExample(propName.toString(), mediaType, schemaProperty, processedModels));
                    }
                    schema.setExample(values);
                }
                return values;
            }
            if (schema instanceof UUIDSchema) {
                return "046b6c7f-0b8a-43b9-b35d-6489e6daee91";
            }
        }
        return "";
    }

    private double randomNumber(Double min, Double max) {
        if (min != null && max != null) {
            double range = max - min;
            return this.random.nextDouble() * range + min;
        }
        if (min != null) {
            return this.random.nextDouble() + min;
        }
        if (max != null) {
            return this.random.nextDouble() * max;
        }
        return this.random.nextDouble() * 10.0;
    }

    private Object resolveModelToExample(String name, String mediaType, Schema schema, Set<String> processedModels) {
        if (processedModels.contains(schema.get$ref())) {
            return schema.getExample();
        }
        if (StringUtils.isNotBlank((CharSequence)schema.get$ref())) {
            processedModels.add(schema.get$ref());
        }
        HashMap<String, Object> values = new HashMap<String, Object>();
        logger.debug("Resolving model '{}' to example", (Object)name);
        if (schema.getExample() != null) {
            logger.debug("Using example from spec: {}", schema.getExample());
            return schema.getExample();
        }
        if (schema.getProperties() != null) {
            logger.debug("Creating example from model values");
            for (Object propertyName : schema.getProperties().keySet()) {
                schema.getProperties().get(propertyName.toString());
                values.put(propertyName.toString(), this.resolveSchemaToExample(propertyName.toString(), mediaType, schema, processedModels));
            }
            schema.setExample(values);
        }
        return values;
    }
}

