/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenParameter;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuaClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    static Logger LOGGER = LoggerFactory.getLogger(LuaClientCodegen.class);
    protected String specFolder = "spec";
    protected String packageName = "swagger-client";
    protected String packageVersion = "1.0.0-1";
    protected String apiDocPath = "docs/";
    protected String modelDocPath = "docs/";
    protected String luaRocksFilename = "swagger-client-1.0.0-1.rockspec";

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "lua";
    }

    @Override
    public String getHelp() {
        return "Generates a Lua client library (beta).";
    }

    public LuaClientCodegen() {
        this.outputFolder = "generated-code/lua";
        this.modelTemplateFiles.put("model.mustache", ".lua");
        this.apiTemplateFiles.put("api.mustache", ".lua");
        this.modelDocTemplateFiles.put("model_doc.mustache", ".md");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.templateDir = "lua";
        this.embeddedTemplateDir = "lua";
        this.hideGenerationTimestamp = Boolean.TRUE;
        this.setReservedWordsLowerCase(Arrays.asList("nil", "string", "boolean", "number", "userdata", "thread", "table", "and", "break", "do", "else", "elseif", "end", "false", "for", "function", "if", "in", "local", "nil", "not", "or", "repeat", "return", "then", "true", "until", "while"));
        this.defaultIncludes = new HashSet<String>(Arrays.asList("map", "array"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("nil", "string", "boolean", "number"));
        this.instantiationTypes.clear();
        this.typeMapping.clear();
        this.typeMapping.put("integer", "number");
        this.typeMapping.put("long", "number");
        this.typeMapping.put("number", "number");
        this.typeMapping.put("float", "number");
        this.typeMapping.put("double", "number");
        this.typeMapping.put("boolean", "boolean");
        this.typeMapping.put("string", "string");
        this.typeMapping.put("UUID", "string");
        this.typeMapping.put("date", "string");
        this.typeMapping.put("DateTime", "string");
        this.typeMapping.put("password", "string");
        this.typeMapping.put("file", "string");
        this.typeMapping.put("binary", "string");
        this.typeMapping.put("ByteArray", "string");
        this.typeMapping.put("object", "TODO_OBJECT_MAPPING");
        this.importMapping = new HashMap();
        this.importMapping.put("time.Time", "time");
        this.importMapping.put("*os.File", "os");
        this.importMapping.put("os", "io/ioutil");
        this.cliOptions.clear();
        this.cliOptions.add(new CliOption("packageName", "Lua package name (convention: lowercase).").defaultValue("swagger-client"));
        this.cliOptions.add(new CliOption("packageVersion", "Lua package version.").defaultValue("1.0.0-1"));
        this.cliOptions.add(new CliOption("hideGenerationTimestamp", "Hides the generation timestamp when files are generated.").defaultValue(Boolean.TRUE.toString()));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("packageName")) {
            this.setPackageName((String)this.additionalProperties.get("packageName"));
        }
        if (this.additionalProperties.containsKey("packageVersion")) {
            this.setPackageVersion((String)this.additionalProperties.get("packageVersion"));
        }
        this.additionalProperties.put("packageName", this.packageName);
        this.additionalProperties.put("packageVersion", this.packageVersion);
        this.setLuaRocksFilename(this.packageName + "-" + this.packageVersion + ".rockspec");
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        this.apiTestTemplateFiles.put("api_test.mustache", ".lua");
        this.modelTestTemplateFiles.put("model_test.mustache", ".lua");
        this.apiDocTemplateFiles.clear();
        this.modelDocTemplateFiles.clear();
        this.modelPackage = this.packageName;
        this.apiPackage = this.packageName;
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("luarocks.mustache", "", this.luaRocksFilename));
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return LuaClientCodegen.camelize(name) + '_';
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.packageName + File.separator + "api" + File.separator;
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.packageName + File.separator + "model" + File.separator;
    }

    @Override
    public String toVarName(String name) {
        if ((name = this.sanitizeName(name.replaceAll("-", "_"))).matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord(name = LuaClientCodegen.underscore(name))) {
            name = this.escapeReservedWord(name);
        }
        if (name.matches("^\\d.*")) {
            name = "Var" + name;
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String toModelName(String name) {
        return this.toModelFilename(name);
    }

    @Override
    public String toModelFilename(String name) {
        if (!StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            name = this.modelNamePrefix + "_" + name;
        }
        if (!StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            name = name + "_" + this.modelNameSuffix;
        }
        if (this.isReservedWord(name = this.sanitizeName(name))) {
            LOGGER.warn(name + " (reserved word) cannot be used as model name. Renamed to " + "model_" + name);
            name = "model_" + name;
        }
        if (name.matches("^\\d.*")) {
            LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + "model_" + name);
            name = "model_" + name;
        }
        return LuaClientCodegen.underscore(name);
    }

    @Override
    public String toApiFilename(String name) {
        name = name.replaceAll("-", "_");
        return LuaClientCodegen.underscore(name) + "_api";
    }

    @Override
    public String toApiTestFilename(String name) {
        return this.toApiFilename(name) + "_spec";
    }

    @Override
    public String toModelTestFilename(String name) {
        return this.toModelFilename(name) + "_spec";
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
    }

    @Override
    public String apiTestFileFolder() {
        return this.outputFolder + File.separator + this.specFolder.replace("/", File.separator);
    }

    @Override
    public String modelTestFileFolder() {
        return this.outputFolder + File.separator + this.specFolder.replace("/", File.separator);
    }

    @Override
    public String apiDocFileFolder() {
        return (this.outputFolder + "/" + this.apiDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String modelDocFileFolder() {
        return (this.outputFolder + "/" + this.modelDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String toModelDocFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toApiDocFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String toApiName(String name) {
        return LuaClientCodegen.underscore(super.toApiName(name));
    }

    @Override
    public String getTypeDeclaration(Property p) {
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            Property inner = ap.getItems();
            return this.getTypeDeclaration(inner);
        }
        if (p instanceof MapProperty) {
            MapProperty mp = (MapProperty)p;
            Property inner = mp.getAdditionalProperties();
            return this.getTypeDeclaration(inner);
        }
        String swaggerType = this.getSwaggerType(p);
        if (this.typeMapping.containsKey(swaggerType)) {
            return (String)this.typeMapping.get(swaggerType);
        }
        if (this.typeMapping.containsValue(swaggerType)) {
            return swaggerType;
        }
        if (this.languageSpecificPrimitives.contains(swaggerType)) {
            return swaggerType;
        }
        return this.toModelName(swaggerType);
    }

    @Override
    public String getSwaggerType(Property p) {
        String swaggerType = super.getSwaggerType(p);
        String type = null;
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = swaggerType;
        }
        return type;
    }

    @Override
    public String toOperationId(String operationId) {
        String sanitizedOperationId = this.sanitizeName(operationId);
        if (this.isReservedWord(sanitizedOperationId)) {
            LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + LuaClientCodegen.underscore("call_" + operationId));
            sanitizedOperationId = "call_" + sanitizedOperationId;
        }
        return LuaClientCodegen.underscore(sanitizedOperationId);
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        Map objectMap = (Map)objs.get("operations");
        List operations = (List)objectMap.get("operation");
        for (CodegenOperation op : operations) {
            String[] items = op.path.split("/", -1);
            String luaPath = "";
            int pathParamIndex = 0;
            for (int i = 0; i < items.length; ++i) {
                if (items[i].matches("^\\{(.*)\\}$")) {
                    luaPath = luaPath + "/%s";
                    ++pathParamIndex;
                    continue;
                }
                if (items[i].length() == 0) continue;
                luaPath = luaPath + "/" + items[i];
            }
            op.vendorExtensions.put("x-codegen-path", luaPath);
        }
        return objs;
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        List imports = (List)objs.get("imports");
        String prefix = this.modelPackage();
        Iterator iterator = imports.iterator();
        while (iterator.hasNext()) {
            String _import = (String)((Map)iterator.next()).get("import");
            if (!_import.startsWith(prefix)) continue;
            iterator.remove();
        }
        List recursiveImports = (List)objs.get("imports");
        if (recursiveImports == null) {
            return objs;
        }
        ListIterator<Map<String, String>> listIterator = imports.listIterator();
        while (listIterator.hasNext()) {
            String _import = (String)((Map)listIterator.next()).get("import");
            if (!this.importMapping.containsKey(_import)) continue;
            listIterator.add(this.createMapping("import", (String)this.importMapping.get(_import)));
        }
        return this.postProcessModelsEnum(objs);
    }

    @Override
    protected boolean needToImport(String type) {
        return !this.defaultIncludes.contains(type) && !this.languageSpecificPrimitives.contains(type);
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    public void setLuaRocksFilename(String luaRocksFilename) {
        this.luaRocksFilename = luaRocksFilename;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("]]", "] ]");
    }

    public Map<String, String> createMapping(String key, String value) {
        HashMap<String, String> customImport = new HashMap<String, String>();
        customImport.put(key, value);
        return customImport;
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if ("int".equals(datatype) || "double".equals(datatype) || "float".equals(datatype)) {
            return value;
        }
        return this.escapeText(value);
    }

    @Override
    public String toEnumDefaultValue(String value, String datatype) {
        return datatype + "_" + value;
    }

    @Override
    public String toEnumVarName(String name, String datatype) {
        if (name.length() == 0) {
            return "EMPTY";
        }
        if ("int".equals(datatype) || "double".equals(datatype) || "float".equals(datatype)) {
            String varName = name;
            varName = varName.replaceAll("-", "MINUS_");
            varName = varName.replaceAll("\\+", "PLUS_");
            varName = varName.replaceAll("\\.", "_DOT_");
            return varName;
        }
        if (this.getSymbolName(name) != null) {
            return this.getSymbolName(name).toUpperCase();
        }
        String enumName = this.sanitizeName(LuaClientCodegen.underscore(name).toUpperCase());
        enumName = enumName.replaceFirst("^_", "");
        if (this.isReservedWord(enumName = enumName.replaceFirst("_$", "")) || enumName.matches("\\d.*")) {
            return this.escapeReservedWord(enumName);
        }
        return enumName;
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        String enumName = LuaClientCodegen.underscore(this.toModelName(property.name)).toUpperCase();
        if ((enumName = enumName.replace("[]", "")).matches("\\d.*")) {
            return "_" + enumName;
        }
        return enumName;
    }

    @Override
    public String toModelImport(String name) {
        if (this.needToImport(this.toModelName(name))) {
            return this.toModelName(name);
        }
        return name;
    }
}

