/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.testing;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Scope;
import io.takari.maven.testing.Maven311Runtime;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.MojoExecutionEvent;
import org.apache.maven.execution.MojoExecutionListener;
import org.apache.maven.execution.scope.MojoExecutionScoped;
import org.apache.maven.execution.scope.internal.MojoExecutionScope;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;

class Maven321Runtime
extends Maven311Runtime {
    public static Maven321Runtime create(Module[] modules) throws Exception {
        Module[] joined = new Module[modules.length + 1];
        joined[0] = new MojoExecutionScopeModule();
        System.arraycopy(modules, 0, joined, 1, modules.length);
        return new Maven321Runtime(joined);
    }

    protected Maven321Runtime(Module[] modules) throws Exception {
        super(modules);
    }

    @Override
    public Mojo executeMojo(MavenSession session, MavenProject project, MojoExecution execution) throws Exception {
        Object sessionScope = this.container.lookup("org.apache.maven.SessionScope");
        try {
            Mojo mojo;
            Maven321Runtime.enter(sessionScope);
            Maven321Runtime.seed(sessionScope, MavenSession.class, session);
            MojoExecutionScope executionScope = (MojoExecutionScope)this.container.lookup(MojoExecutionScope.class);
            try {
                executionScope.enter();
                executionScope.seed(MavenProject.class, (Object)project);
                executionScope.seed(MojoExecution.class, (Object)execution);
                Mojo mojo2 = this.lookupConfiguredMojo(session, execution);
                mojo2.execute();
                MojoExecutionEvent event = new MojoExecutionEvent(session, project, execution, mojo2);
                for (MojoExecutionListener listener : this.container.lookupList(MojoExecutionListener.class)) {
                    listener.afterMojoExecutionSuccess(event);
                }
                mojo = mojo2;
            }
            catch (Throwable throwable) {
                executionScope.exit();
                throw throwable;
            }
            executionScope.exit();
            return mojo;
        }
        finally {
            Maven321Runtime.exit(sessionScope);
        }
    }

    private static void enter(Object scope) throws Exception {
        scope.getClass().getMethod("enter", new Class[0]).invoke(scope, new Object[0]);
    }

    private static void seed(Object scope, Class type, Object instance) throws Exception {
        scope.getClass().getMethod("seed", Class.class, Object.class).invoke(scope, type, instance);
    }

    private static void exit(Object scope) throws Exception {
        scope.getClass().getMethod("exit", new Class[0]).invoke(scope, new Object[0]);
    }

    private static class MojoExecutionScopeModule
    extends AbstractModule {
        private MojoExecutionScopeModule() {
        }

        protected void configure() {
            MojoExecutionScope scope = new MojoExecutionScope();
            this.bind(MojoExecutionScope.class).toInstance((Object)scope);
            this.bindScope(MojoExecutionScoped.class, (Scope)scope);
            this.bind(MavenProject.class).toProvider(MojoExecutionScope.seededKeyProvider()).in((Scope)scope);
            this.bind(MojoExecution.class).toProvider(MojoExecutionScope.seededKeyProvider()).in((Scope)scope);
        }
    }
}

