/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.testing;

import com.google.inject.Module;
import io.takari.maven.testing.Maven30xRuntime;
import io.takari.maven.testing.Maven311Runtime;
import io.takari.maven.testing.Maven321Runtime;
import io.takari.maven.testing.Maven325Runtime;
import io.takari.maven.testing.Maven331Runtime;
import io.takari.maven.testing.MavenRuntime;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.junit.Assert;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class TestMavenRuntime
implements TestRule {
    private static final DefaultArtifactVersion MAVEN_VERSION;
    private static final Map<VersionRange, RuntimeFactory> FACTORIES;
    private final Module[] modules;
    private MavenRuntime runtime;

    static {
        DefaultArtifactVersion version = null;
        String path = "/META-INF/maven/org.apache.maven/maven-core/pom.properties";
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream is = TestMavenRuntime.class.getResourceAsStream(path);){
                String property;
                Properties properties = new Properties();
                if (is != null) {
                    properties.load(is);
                }
                if ((property = properties.getProperty("version")) != null) {
                    version = new DefaultArtifactVersion(property);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
        MAVEN_VERSION = version;
        LinkedHashMap<VersionRange, RuntimeFactory> factories = new LinkedHashMap<VersionRange, RuntimeFactory>();
        try {
            factories.put(VersionRange.createFromVersionSpec((String)"[3.0,3.1.1)"), new RuntimeFactory(){

                @Override
                public MavenRuntime newInstance(Module[] modules) throws Exception {
                    return new Maven30xRuntime(modules);
                }
            });
            factories.put(VersionRange.createFromVersionSpec((String)"[3.1.1,3.2.1)"), new RuntimeFactory(){

                @Override
                public MavenRuntime newInstance(Module[] modules) throws Exception {
                    return new Maven311Runtime(modules);
                }
            });
            factories.put(VersionRange.createFromVersionSpec((String)"[3.2.1,3.2.5)"), new RuntimeFactory(){

                @Override
                public MavenRuntime newInstance(Module[] modules) throws Exception {
                    return Maven321Runtime.create(modules);
                }
            });
            factories.put(VersionRange.createFromVersionSpec((String)"[3.2.5]"), new RuntimeFactory(){

                @Override
                public MavenRuntime newInstance(Module[] modules) throws Exception {
                    return new Maven325Runtime(modules);
                }
            });
            factories.put(VersionRange.createFromVersionSpec((String)"(3.2.5,]"), new RuntimeFactory(){

                @Override
                public MavenRuntime newInstance(Module[] modules) throws Exception {
                    return new Maven331Runtime(modules);
                }
            });
        }
        catch (InvalidVersionSpecificationException e) {
            throw new RuntimeException(e);
        }
        FACTORIES = Collections.unmodifiableMap(factories);
    }

    public TestMavenRuntime() {
        this(new Module[0]);
    }

    public TestMavenRuntime(Module ... modules) {
        this.modules = modules;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                TestMavenRuntime.this.runtime = TestMavenRuntime.this.newMavenRuntime(TestMavenRuntime.this.modules);
                try {
                    base.evaluate();
                }
                finally {
                    TestMavenRuntime.this.runtime.shutdown();
                    TestMavenRuntime.this.runtime = null;
                }
            }
        };
    }

    private MavenRuntime newMavenRuntime(Module[] modules) throws Exception {
        for (Map.Entry<VersionRange, RuntimeFactory> entry : FACTORIES.entrySet()) {
            if (!entry.getKey().containsVersion((ArtifactVersion)MAVEN_VERSION)) continue;
            return entry.getValue().newInstance(modules);
        }
        throw new AssertionError((Object)String.format("Maven version %s is not supported, supprted versions: %s", MAVEN_VERSION, FACTORIES.entrySet()));
    }

    public MavenProject readMavenProject(File basedir) throws Exception {
        MavenProject project = this.runtime.readMavenProject(basedir);
        Assert.assertNotNull((Object)project);
        return project;
    }

    public MavenSession newMavenSession(MavenProject project) throws Exception {
        MavenSession session = this.runtime.newMavenSession(project.getBasedir());
        session.setCurrentProject(project);
        session.setProjects(Arrays.asList(project));
        return session;
    }

    public MojoExecution newMojoExecution(String goal, Xpp3Dom ... parameters) {
        MojoExecution execution = this.runtime.newMojoExecution(goal);
        if (parameters != null) {
            Xpp3Dom configuration = execution.getConfiguration();
            Xpp3Dom[] xpp3DomArray = parameters;
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                Xpp3Dom parameter = xpp3DomArray[n2];
                configuration.addChild(parameter);
                ++n2;
            }
        }
        return execution;
    }

    public void executeMojo(File basedir, String goal, Xpp3Dom ... parameters) throws Exception {
        MavenProject project = this.readMavenProject(basedir);
        MavenSession session = this.newMavenSession(project);
        this.executeMojo(session, project, goal, parameters);
    }

    public void executeMojo(MavenSession session, MavenProject project, String goal, Xpp3Dom ... parameters) throws Exception {
        MojoExecution execution = this.newMojoExecution(goal, parameters);
        this.executeMojo(session, project, execution);
    }

    public void executeMojo(MavenProject project, String goal, Xpp3Dom ... parameters) throws Exception {
        MavenSession session = this.newMavenSession(project);
        this.executeMojo(session, project, goal, parameters);
    }

    public void executeMojo(MavenSession session, MavenProject project, MojoExecution execution) throws Exception {
        this.runtime.executeMojo(session, project, execution);
    }

    public Mojo lookupConfiguredMojo(MavenSession session, MojoExecution execution) throws Exception {
        return this.runtime.lookupConfiguredMojo(session, execution);
    }

    public DefaultPlexusContainer getContainer() {
        return this.runtime.getContainer();
    }

    public <T> T lookup(Class<T> role) throws Exception {
        return this.runtime.lookup(role);
    }

    public static Xpp3Dom newParameter(String name, String value) {
        Xpp3Dom child = new Xpp3Dom(name);
        child.setValue(value);
        return child;
    }

    public TestDependency newDependency(File artifact) {
        return new TestDependency(artifact);
    }

    private static interface RuntimeFactory {
        public MavenRuntime newInstance(Module[] var1) throws Exception;
    }

    public class TestDependency {
        private final File file;
        private String groupId = "test";
        private String artifactId;
        private String classifier;
        private String version = "1.0";
        private String type = "jar";
        private String scope = "compile";
        private boolean optional;

        private TestDependency(File artifact) {
            this.file = artifact;
            this.artifactId = artifact.getName();
        }

        public TestDependency setArtifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        public TestDependency setGroupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public TestDependency setVersion(String version) {
            this.version = version;
            return this;
        }

        public TestDependency setType(String type) {
            this.type = type;
            return this;
        }

        public TestDependency setOptional(boolean optional) {
            this.optional = optional;
            return this;
        }

        public TestDependency setClassifier(String classifier) {
            this.classifier = classifier;
            return this;
        }

        public TestDependency setScope(String scope) {
            this.scope = scope;
            return this;
        }

        public TestDependency addTo(MavenProject project) throws Exception {
            return this.addTo(project, true);
        }

        public TestDependency addTo(MavenProject project, boolean direct) throws Exception {
            ArtifactHandler handler = (ArtifactHandler)TestMavenRuntime.this.getContainer().lookup(ArtifactHandler.class, this.type);
            DefaultArtifact artifact = new DefaultArtifact(this.groupId, this.artifactId, this.version, this.scope, this.type, this.classifier, handler);
            artifact.setFile(this.file);
            artifact.setOptional(this.optional);
            Set artifacts = project.getArtifacts();
            artifacts.add(artifact);
            project.setArtifacts(artifacts);
            if (direct) {
                LinkedHashSet<DefaultArtifact> directDependencies = project.getDependencyArtifacts();
                directDependencies = directDependencies == null ? new LinkedHashSet<DefaultArtifact>() : new LinkedHashSet(directDependencies);
                directDependencies.add(artifact);
                project.setDependencyArtifacts(directDependencies);
            }
            return this;
        }
    }
}

