/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.common;

import io.temporal.internal.common.SdkFlag;
import io.temporal.workflow.Functions;
import java.util.EnumSet;

public final class SdkFlags {
    private final boolean supportSdkMetadata;
    private final Functions.Func<Boolean> replaying;
    private final EnumSet<SdkFlag> sdkFlags = EnumSet.noneOf(SdkFlag.class);
    private final EnumSet<SdkFlag> unsentSdkFlags = EnumSet.noneOf(SdkFlag.class);

    public SdkFlags(boolean supportSdkMetadata, Functions.Func<Boolean> replaying) {
        this.supportSdkMetadata = supportSdkMetadata;
        this.replaying = replaying;
    }

    public boolean setSdkFlag(SdkFlag flag) {
        if (!this.supportSdkMetadata) {
            return false;
        }
        this.sdkFlags.add(flag);
        return true;
    }

    public boolean tryUseSdkFlag(SdkFlag flag) {
        if (!this.supportSdkMetadata) {
            return false;
        }
        if (!this.replaying.apply().booleanValue()) {
            this.sdkFlags.add(flag);
            this.unsentSdkFlags.add(flag);
            return true;
        }
        return this.sdkFlags.contains((Object)flag);
    }

    public EnumSet<SdkFlag> takeNewSdkFlags() {
        Object result = this.unsentSdkFlags.clone();
        this.unsentSdkFlags.clear();
        return result;
    }
}

