/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.common.env;

import com.google.common.base.Joiner;

public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static String getMethodNameForStackTraceCutoff(Class<?> clazz, String methodName, Class<?> ... parameterTypes) throws RuntimeException {
        try {
            return clazz.getName() + "." + clazz.getMethod(methodName, parameterTypes).getName();
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Reflection code that publishes the methods signatures is out of sync with actual method signatures. Class '" + clazz.getCanonicalName() + "' is expected to have method '" + methodName + "' with parameters {" + Joiner.on((String)", ").join((Object[])parameterTypes) + "}", e);
        }
    }
}

