/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.serviceclient;

import com.google.common.base.Preconditions;
import io.grpc.BindableService;
import io.grpc.ManagedChannel;
import io.grpc.health.v1.HealthCheckResponse;
import io.temporal.api.workflowservice.v1.GetSystemInfoResponse;
import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import io.temporal.internal.testservice.InProcessGRPCServer;
import io.temporal.serviceclient.ChannelManager;
import io.temporal.serviceclient.GrpcDeadlineInterceptor;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.serviceclient.WorkflowServiceStubsOptions;
import java.time.Duration;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class WorkflowServiceStubsImpl
implements WorkflowServiceStubs {
    private static final Logger log = LoggerFactory.getLogger(WorkflowServiceStubsImpl.class);
    private final WorkflowServiceStubsOptions options;
    private final InProcessGRPCServer inProcessServer;
    private final ChannelManager channelManager;
    private final WorkflowServiceGrpc.WorkflowServiceBlockingStub blockingStub;
    private final WorkflowServiceGrpc.WorkflowServiceFutureStub futureStub;

    WorkflowServiceStubsImpl(BindableService serviceImpl, WorkflowServiceStubsOptions options) {
        Preconditions.checkArgument((serviceImpl == null || options.getChannel() == null ? 1 : 0) != 0, (Object)"both channel and serviceImpl present");
        if (serviceImpl != null) {
            this.inProcessServer = new InProcessGRPCServer(Collections.singletonList(serviceImpl));
            options = ((WorkflowServiceStubsOptions.Builder)((WorkflowServiceStubsOptions.Builder)WorkflowServiceStubsOptions.newBuilder(options).setChannel(this.inProcessServer.getChannel())).setTarget(null)).build();
        } else {
            this.inProcessServer = null;
        }
        this.options = WorkflowServiceStubsOptions.newBuilder(options).validateAndBuildWithDefaults();
        this.options.getRpcRetryOptions().validate();
        GrpcDeadlineInterceptor deadlineInterceptor = new GrpcDeadlineInterceptor(options.getRpcTimeout(), options.getRpcLongPollTimeout(), options.getRpcQueryTimeout());
        this.channelManager = new ChannelManager(this.options, Collections.singletonList(deadlineInterceptor));
        log.info(String.format("Created WorkflowServiceStubs for channel: %s", this.channelManager.getRawChannel()));
        this.blockingStub = WorkflowServiceGrpc.newBlockingStub(this.channelManager.getInterceptedChannel());
        this.futureStub = WorkflowServiceGrpc.newFutureStub(this.channelManager.getInterceptedChannel());
    }

    @Override
    public WorkflowServiceGrpc.WorkflowServiceBlockingStub blockingStub() {
        return this.blockingStub;
    }

    @Override
    public WorkflowServiceGrpc.WorkflowServiceFutureStub futureStub() {
        return this.futureStub;
    }

    @Override
    public ManagedChannel getRawChannel() {
        return this.channelManager.getRawChannel();
    }

    @Override
    public void shutdown() {
        log.info("shutdown");
        this.channelManager.shutdown();
        if (this.inProcessServer != null) {
            this.inProcessServer.shutdown();
        }
    }

    @Override
    public void shutdownNow() {
        log.info("shutdownNow");
        this.channelManager.shutdownNow();
        if (this.inProcessServer != null) {
            this.inProcessServer.shutdownNow();
        }
    }

    @Override
    public boolean isShutdown() {
        boolean result = this.channelManager.isShutdown();
        if (this.inProcessServer != null) {
            result = result && this.inProcessServer.isShutdown();
        }
        return result;
    }

    @Override
    public boolean isTerminated() {
        boolean result = this.channelManager.isTerminated();
        if (this.inProcessServer != null) {
            result = result && this.inProcessServer.isTerminated();
        }
        return result;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) {
        long start = System.currentTimeMillis();
        long deadline = start + unit.toMillis(timeout);
        if (!this.channelManager.awaitTermination(timeout, unit)) {
            return false;
        }
        if (this.inProcessServer != null) {
            long left = deadline - System.currentTimeMillis();
            return this.inProcessServer.awaitTermination(left, TimeUnit.MILLISECONDS);
        }
        return true;
    }

    @Override
    public void connect(@Nullable Duration timeout) {
        this.channelManager.connect("temporal.api.workflowservice.v1.WorkflowService", timeout);
    }

    @Override
    public HealthCheckResponse healthCheck() {
        return this.channelManager.healthCheck("temporal.api.workflowservice.v1.WorkflowService", null);
    }

    @Override
    public Supplier<GetSystemInfoResponse.Capabilities> getServerCapabilities() {
        return this.channelManager.getServerCapabilities();
    }

    @Override
    public WorkflowServiceStubsOptions getOptions() {
        return this.options;
    }
}

