/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.redis.client.RedisClusterConnectOptions;
import io.vertx.redis.client.RedisClusterTransactions;
import io.vertx.redis.client.RedisReplicas;
import java.util.Base64;
import java.util.Map;

public class RedisClusterConnectOptionsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    static void fromJson(Iterable<Map.Entry<String, Object>> json, RedisClusterConnectOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "clusterTransactions": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setClusterTransactions(RedisClusterTransactions.valueOf((String)member.getValue()));
                    break;
                }
                case "hashSlotCacheTTL": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setHashSlotCacheTTL(((Number)member.getValue()).longValue());
                    break;
                }
                case "useReplicas": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setUseReplicas(RedisReplicas.valueOf((String)member.getValue()));
                }
            }
        }
    }

    static void toJson(RedisClusterConnectOptions obj, JsonObject json) {
        RedisClusterConnectOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(RedisClusterConnectOptions obj, Map<String, Object> json) {
        if (obj.getClusterTransactions() != null) {
            json.put("clusterTransactions", obj.getClusterTransactions().name());
        }
        json.put("hashSlotCacheTTL", obj.getHashSlotCacheTTL());
        if (obj.getUseReplicas() != null) {
            json.put("useReplicas", obj.getUseReplicas().name());
        }
    }
}

