/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.web.codec;

import java.util.Map;
import rx.Observable;
import rx.Single;
import io.vertx.core.json.JsonArray;
import io.vertx.rxjava.core.buffer.Buffer;
import io.vertx.rxjava.core.streams.WriteStream;
import io.vertx.core.json.JsonObject;
import java.util.function.Function;

/**
 * A codec for encoding and decoding HTTP bodies.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.codec.BodyCodec original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rxjava.RxGen(io.vertx.ext.web.codec.BodyCodec.class)
public class BodyCodec<T> {

  public static final io.vertx.lang.rxjava.TypeArg<BodyCodec> __TYPE_ARG = new io.vertx.lang.rxjava.TypeArg<>(
    obj -> new BodyCodec((io.vertx.ext.web.codec.BodyCodec) obj),
    BodyCodec::getDelegate
  );

  private final io.vertx.ext.web.codec.BodyCodec delegate;
  public final io.vertx.lang.rxjava.TypeArg<T> __typeArg_0;
  
  public BodyCodec(io.vertx.ext.web.codec.BodyCodec delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.vertx.lang.rxjava.TypeArg.unknown();
  }

  public BodyCodec(io.vertx.ext.web.codec.BodyCodec delegate, io.vertx.lang.rxjava.TypeArg<T> typeArg_0) {
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
  }

  public io.vertx.ext.web.codec.BodyCodec getDelegate() {
    return delegate;
  }

  /**
   * @return the UTF-8 string codec
   */
  public static BodyCodec<String> string() { 
    BodyCodec<String> ret = BodyCodec.newInstance(io.vertx.ext.web.codec.BodyCodec.string(), io.vertx.lang.rxjava.TypeArg.unknown());
    return ret;
  }

  /**
   * A codec for strings using a specific <code>encoding</code>.
   * @param encoding the encoding
   * @return the codec
   */
  public static BodyCodec<String> string(String encoding) { 
    BodyCodec<String> ret = BodyCodec.newInstance(io.vertx.ext.web.codec.BodyCodec.string(encoding), io.vertx.lang.rxjava.TypeArg.unknown());
    return ret;
  }

  /**
   * @return the  codec
   */
  public static BodyCodec<Buffer> buffer() { 
    BodyCodec<Buffer> ret = BodyCodec.newInstance(io.vertx.ext.web.codec.BodyCodec.buffer(), io.vertx.rxjava.core.buffer.Buffer.__TYPE_ARG);
    return ret;
  }

  /**
   * @return the  codec
   */
  public static BodyCodec<JsonObject> jsonObject() { 
    BodyCodec<JsonObject> ret = BodyCodec.newInstance(io.vertx.ext.web.codec.BodyCodec.jsonObject(), io.vertx.lang.rxjava.TypeArg.unknown());
    return ret;
  }

  /**
   * @return the  codec
   */
  public static BodyCodec<JsonArray> jsonArray() { 
    BodyCodec<JsonArray> ret = BodyCodec.newInstance(io.vertx.ext.web.codec.BodyCodec.jsonArray(), io.vertx.lang.rxjava.TypeArg.unknown());
    return ret;
  }

  /**
   * Create and return a codec for Java objects encoded using Jackson mapper.
   * @param type 
   * @return a codec for mapping POJO to Json
   */
  public static <U> BodyCodec<U> json(Class<U> type) { 
    BodyCodec<U> ret = BodyCodec.newInstance(io.vertx.ext.web.codec.BodyCodec.json(io.vertx.lang.rxjava.Helper.unwrap(type)), io.vertx.lang.rxjava.TypeArg.of(type));
    return ret;
  }

  /**
   * @return a codec that simply discards the response
   */
  public static BodyCodec<Void> none() { 
    BodyCodec<Void> ret = BodyCodec.newInstance(io.vertx.ext.web.codec.BodyCodec.none(), io.vertx.lang.rxjava.TypeArg.unknown());
    return ret;
  }

  /**
   * Create a codec that buffers the entire body and then apply the <code>decode</code> function and returns the result.
   * @param decode the decode function
   * @return the created codec
   */
  public static <T> BodyCodec<T> create(Function<Buffer,T> decode) { 
    BodyCodec<T> ret = BodyCodec.newInstance(io.vertx.ext.web.codec.BodyCodec.create(new java.util.function.Function<io.vertx.core.buffer.Buffer,T>() {
      public T apply(io.vertx.core.buffer.Buffer arg) {
        T ret = decode.apply(Buffer.newInstance(arg));
        return ret;
      }
    }), io.vertx.lang.rxjava.TypeArg.unknown());
    return ret;
  }

  /**
   * A body codec that pipes the body to a write stream.
   * @param stream the destination tream
   * @return the body codec for a write stream
   */
  public static BodyCodec<Void> pipe(WriteStream<Buffer> stream) { 
    BodyCodec<Void> ret = BodyCodec.newInstance(io.vertx.ext.web.codec.BodyCodec.pipe(stream.getDelegate()), io.vertx.lang.rxjava.TypeArg.unknown());
    return ret;
  }


  public static <T>BodyCodec<T> newInstance(io.vertx.ext.web.codec.BodyCodec arg) {
    return arg != null ? new BodyCodec<T>(arg) : null;
  }

  public static <T>BodyCodec<T> newInstance(io.vertx.ext.web.codec.BodyCodec arg, io.vertx.lang.rxjava.TypeArg<T> __typeArg_T) {
    return arg != null ? new BodyCodec<T>(arg, __typeArg_T) : null;
  }
}
