/*
 * Decompiled with CFR 0.152.
 */
package brave.propagation.tracecontext;

import brave.propagation.tracecontext.internal.Nullable;

final class Tracestate {
    static final Tracestate EMPTY = new Tracestate(null);
    @Nullable
    final CharSequence otherState;

    Tracestate(CharSequence otherState) {
        this.otherState = otherState;
    }

    static Tracestate create(CharSequence otherState) {
        return otherState != null && otherState.length() > 0 ? new Tracestate(otherState) : EMPTY;
    }

    String stateString(String thisKey, String thisValue) {
        int length = thisKey.length() + 1 + thisValue.length();
        if (this.otherState != null) {
            length += 1 + this.otherState.length();
        }
        StringBuilder result = new StringBuilder(length);
        result.append(thisKey).append('=').append(thisValue);
        if (this.otherState != null) {
            result.append(',').append(this.otherState);
        }
        return result.toString();
    }

    public String toString() {
        if (this.otherState == null) {
            return "Tracestate{}";
        }
        return "Tracestate{" + this.otherState + "}";
    }
}

