/*
 * Decompiled with CFR 0.152.
 */
package jp.skypencil.findbugs.slf4j;

import com.google.common.base.Objects;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Field;

public class StaticLoggerDetector
extends OpcodeStackDetector {
    private final BugReporter bugReporter;

    public StaticLoggerDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(Field field) {
        if (field.isStatic() && Objects.equal(field.getSignature(), "Lorg/slf4j/Logger;")) {
            BugInstance bug = new BugInstance((Detector)this, "SLF4J_LOGGER_SHOULD_BE_NON_STATIC", 3).addString(field.getName()).addField((PreorderVisitor)this).addClass((PreorderVisitor)this);
            this.bugReporter.reportBug(bug);
        }
    }

    public void sawOpcode(int code) {
    }
}

