/*
 * Decompiled with CFR 0.152.
 */
package jp.skypencil.findbugs.slf4j;

import com.google.common.base.Objects;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import jp.skypencil.findbugs.slf4j.CodepointIterator;
import jp.skypencil.findbugs.slf4j.parameter.AbstractDetectorForParameterArray;
import jp.skypencil.findbugs.slf4j.parameter.ArrayData;
import jp.skypencil.findbugs.slf4j.parameter.ArrayDataHandler;
import jp.skypencil.findbugs.slf4j.parameter.ThrowableHandler;

@OpcodeStack.CustomUserValue
public class WrongPlaceholderDetector
extends AbstractDetectorForParameterArray {
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("(.?)(\\\\\\\\)*\\{\\}");
    private static final Pattern SIGNATURE_PATTERN = Pattern.compile("^\\((.*)\\).*$");

    public WrongPlaceholderDetector(BugReporter bugReporter) {
        super(bugReporter);
    }

    @Override
    public void sawOpcode(int seen, ThrowableHandler throwableHandler) {
    }

    @Override
    protected void onLog(@Nullable String format, @Nullable ArrayData arrayData) {
        int parameterCount;
        if (format == null) {
            return;
        }
        this.verifyFormat(format);
        String signature = this.getSigConstantOperand();
        int placeholderCount = this.countPlaceholder(format);
        try {
            parameterCount = this.countParameter(this.stack, signature, this.getThrowableHandler());
        }
        catch (IllegalStateException e) {
            BugInstance bug = new BugInstance((Detector)this, "SLF4J_UNKNOWN_ARRAY", 1).addSourceLine((BytecodeScanningDetector)this).addClassAndMethod((PreorderVisitor)this).addCalledMethod((DismantleBytecode)this);
            this.getBugReporter().reportBug(bug);
            return;
        }
        if (placeholderCount != parameterCount) {
            BugInstance bug = new BugInstance((Detector)this, "SLF4J_PLACE_HOLDER_MISMATCH", 1).addInt(placeholderCount).addInt(parameterCount).addSourceLine((BytecodeScanningDetector)this).addClassAndMethod((PreorderVisitor)this).addCalledMethod((DismantleBytecode)this);
            this.getBugReporter().reportBug(bug);
        }
    }

    private void verifyFormat(String formatString) {
        CodepointIterator iterator = new CodepointIterator(formatString);
        while (iterator.hasNext()) {
            if (!Character.isLetter(iterator.next())) continue;
            return;
        }
        BugInstance bug = new BugInstance((Detector)this, "SLF4J_SIGN_ONLY_FORMAT", 2).addString(formatString).addSourceLine((BytecodeScanningDetector)this).addClassAndMethod((PreorderVisitor)this).addCalledMethod((DismantleBytecode)this);
        this.getBugReporter().reportBug(bug);
    }

    int countParameter(OpcodeStack stack, String methodSignature, ThrowableHandler throwableHandler) {
        OpcodeStack.Item lastItem;
        String[] signatures = this.splitSignature(methodSignature);
        if (Objects.equal(signatures[signatures.length - 1], "[Ljava/lang/Object;")) {
            ArrayData arrayData = (ArrayData)stack.getStackItem(0).getUserValue();
            if (arrayData == null || arrayData.getSize() < 0) {
                throw new IllegalStateException("no array initializer found");
            }
            int parameterCount = arrayData.getSize();
            if (arrayData.isMarked()) {
                --parameterCount;
            }
            return parameterCount;
        }
        int parameterCount = signatures.length - 1;
        if (Objects.equal(signatures[0], "Lorg/slf4j/Marker;")) {
            --parameterCount;
        }
        if (throwableHandler.checkThrowable(lastItem = stack.getStackItem(0))) {
            --parameterCount;
        }
        return parameterCount;
    }

    int countPlaceholder(String format) {
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(format);
        int count = 0;
        while (matcher.find()) {
            if (Objects.equal("\\", matcher.group(1))) continue;
            ++count;
        }
        return count;
    }

    private String[] splitSignature(String methodSignature) {
        Matcher matcher = SIGNATURE_PATTERN.matcher(methodSignature);
        if (matcher.find()) {
            String[] arguments = matcher.group(1).split(";");
            for (int i = 0; i < arguments.length; ++i) {
                arguments[i] = arguments[i] + ';';
            }
            return arguments;
        }
        throw new IllegalArgumentException();
    }

    @Override
    protected ArrayDataHandler.Strategy createArrayCheckStrategy() {
        return new ArrayDataHandler.Strategy(){

            @Override
            public void store(OpcodeStack.Item storedItem, ArrayData data, int index) {
                if (data != null && data.getSize() - 1 == index) {
                    data.mark(WrongPlaceholderDetector.this.getThrowableHandler().checkThrowable(storedItem));
                }
            }
        };
    }
}

