/*
 * Decompiled with CFR 0.152.
 */
package jp.skypencil.findbugs.slf4j.parameter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import jp.skypencil.findbugs.slf4j.parameter.ArrayData;
import jp.skypencil.findbugs.slf4j.parameter.ArrayDataHandler;
import jp.skypencil.findbugs.slf4j.parameter.ThrowableHandler;
import org.apache.bcel.classfile.Method;

public abstract class AbstractDetectorForParameterArray
extends OpcodeStackDetector {
    private static final ImmutableSet<String> TARGET_METHOD_NAMES = ImmutableSet.of("trace", "debug", "info", "warn", "error");
    private static final ImmutableSet<String> SIGS_WITHOUT_FORMAT = ImmutableSet.of("(Ljava/lang/String;)V", "(Lorg/slf4j/Maker;Ljava/lang/String;)V", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "(Lorg/slf4j/Maker;Ljava/lang/String;Ljava/lang/Throwable;)V");
    private static final Pattern SIGNATURE_PATTERN = Pattern.compile("^\\((.*)\\).*$");
    private final BugReporter bugReporter;
    private final ThrowableHandler throwableHandler;
    private final ArrayDataHandler arrayDataHandler;

    public AbstractDetectorForParameterArray(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.throwableHandler = new ThrowableHandler();
        this.arrayDataHandler = new ArrayDataHandler(this.createArrayCheckStrategy());
    }

    protected abstract ArrayDataHandler.Strategy createArrayCheckStrategy();

    public final void sawOpcode(int seen) {
        this.throwableHandler.sawOpcode(this, seen);
        try {
            this.checkEvents(seen);
            this.sawOpcode(seen, this.throwableHandler);
        }
        finally {
            this.arrayDataHandler.sawOpcode(this.stack, seen);
        }
    }

    public void visitMethod(Method method) {
        this.throwableHandler.visitMethod();
        super.visitMethod(method);
    }

    private void checkEvents(int seen) {
        if (seen == 185) {
            if (!Objects.equal("org/slf4j/Logger", this.getClassConstantOperand()) || !TARGET_METHOD_NAMES.contains(this.getNameConstantOperand())) {
                return;
            }
            String signature = this.getSigConstantOperand();
            String formatString = this.findFormatString(signature);
            ArrayData arrayData = this.findArrayData(signature);
            this.onLog(formatString, arrayData);
        }
    }

    @Nullable
    private ArrayData findArrayData(String signature) {
        int stackIndex = AbstractDetectorForParameterArray.indexOf(signature, "[Ljava/lang/Object;");
        if (stackIndex == -1) {
            String[] signatures = AbstractDetectorForParameterArray.splitSignature(signature);
            int parameterOffset = 0;
            int parameterCount = signatures.length - 1;
            if (signatures[0].equals("Lorg/slf4j/Marker;")) {
                --parameterCount;
                parameterOffset = 1;
            }
            ArrayData data = new ArrayData(parameterCount);
            for (int i = 0; i < data.getSize(); ++i) {
                OpcodeStack.Item item = this.getStack().getStackItem(i + parameterOffset);
                this.arrayDataHandler.store(item, data, i);
            }
            return data;
        }
        Object userValue = this.getStack().getStackItem(stackIndex).getUserValue();
        if (userValue instanceof ArrayData) {
            return (ArrayData)userValue;
        }
        return null;
    }

    @Nullable
    private String findFormatString(String signature) {
        int stackIndex = AbstractDetectorForParameterArray.indexOf(signature, "Ljava/lang/String;");
        Object constant = this.getStack().getStackItem(stackIndex).getConstant();
        if (constant == null) {
            BugInstance bug = new BugInstance((Detector)this, "SLF4J_FORMAT_SHOULD_BE_CONST", 1).addSourceLine((BytecodeScanningDetector)this).addClassAndMethod((PreorderVisitor)this).addCalledMethod((DismantleBytecode)this);
            this.bugReporter.reportBug(bug);
            return null;
        }
        if (SIGS_WITHOUT_FORMAT.contains(signature)) {
            return null;
        }
        return constant.toString();
    }

    @VisibleForTesting
    static int indexOf(String methodSignature, String targetType) {
        String[] arguments = AbstractDetectorForParameterArray.splitSignature(methodSignature);
        int index = arguments.length;
        for (String type : arguments) {
            --index;
            if (!Objects.equal(type, targetType)) continue;
            return index;
        }
        return -1;
    }

    private static String[] splitSignature(String methodSignature) {
        Matcher matcher = SIGNATURE_PATTERN.matcher(methodSignature);
        if (matcher.find()) {
            String[] arguments = matcher.group(1).split(";");
            for (int i = 0; i < arguments.length; ++i) {
                arguments[i] = arguments[i] + ';';
            }
            return arguments;
        }
        throw new IllegalArgumentException();
    }

    protected abstract void sawOpcode(int var1, ThrowableHandler var2);

    @OverridingMethodsMustInvokeSuper
    public void afterOpcode(int seen) {
        ArrayData newUserValueToSet = this.arrayDataHandler.afterOpcode(this.stack, seen, this.getClassName(), this.getPC());
        super.afterOpcode(seen);
        if (newUserValueToSet != null) {
            OpcodeStack.Item createdArray = this.stack.getStackItem(0);
            createdArray.setUserValue((Object)newUserValueToSet);
        }
        this.throwableHandler.afterOpcode(this, seen);
    }

    protected final BugReporter getBugReporter() {
        return this.bugReporter;
    }

    protected final ThrowableHandler getThrowableHandler() {
        return this.throwableHandler;
    }

    protected void onLog(@Nullable String format, @Nullable ArrayData arrayData) {
    }
}

