/*
 * Decompiled with CFR 0.152.
 */
package jp.skypencil.findbugs.slf4j.parameter;

import edu.umd.cs.findbugs.OpcodeStack;
import jp.skypencil.findbugs.slf4j.parameter.ArrayData;

public class ArrayDataHandler {
    private final Strategy strategy;

    ArrayDataHandler(Strategy strategy) {
        this.strategy = strategy;
    }

    void sawOpcode(OpcodeStack stack, int seen) {
        if (seen == 83) {
            this.checkStoredInstance(stack);
        }
    }

    ArrayData afterOpcode(OpcodeStack stack, int seen, String className, int pc) {
        if (seen != 189) {
            return null;
        }
        if (stack.isTop()) {
            System.err.printf("ArrayDataHandler: stack is TOP, cannot be analyzed. %s:%d%n", className, pc);
            return null;
        }
        return this.tryToDetectArraySize(stack);
    }

    private void checkStoredInstance(OpcodeStack stack) {
        OpcodeStack.Item storedValue = stack.getStackItem(0);
        OpcodeStack.Item arrayIndexItem = stack.getStackItem(1);
        OpcodeStack.Item targetArray = stack.getStackItem(2);
        Object arrayIndex = arrayIndexItem.getConstant();
        if (arrayIndex instanceof Number) {
            ArrayData data = (ArrayData)targetArray.getUserValue();
            Number index = (Number)arrayIndex;
            this.store(storedValue, data, index.intValue());
        }
    }

    private ArrayData tryToDetectArraySize(OpcodeStack stack) {
        OpcodeStack.Item arraySizeItem = stack.getStackItem(0);
        int arraySize = arraySizeItem != null && arraySizeItem.getConstant() instanceof Number ? ((Number)arraySizeItem.getConstant()).intValue() : -1;
        return new ArrayData(arraySize);
    }

    void store(OpcodeStack.Item storedItem, ArrayData arrayData, int index) {
        this.strategy.store(storedItem, arrayData, index);
    }

    public static interface Strategy {
        public void store(OpcodeStack.Item var1, ArrayData var2, int var3);
    }
}

