/*
 * Decompiled with CFR 0.152.
 */
package kr.motd.maven.plugin.os;

import java.util.Locale;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="detect", defaultPhase=LifecyclePhase.VALIDATE)
public class DetectMojo
extends AbstractMojo {
    private static final String UNKNOWN = "unknown";
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${os.name}", readonly=true)
    private String osName;
    @Parameter(defaultValue="${os.arch}", readonly=true)
    private String osArch;
    @Parameter(defaultValue="true")
    private boolean failOnUnknownOS;

    public void execute() throws MojoExecutionException {
        String detectedName = DetectMojo.normalizeOs(this.osName);
        String detectedArch = DetectMojo.normalizeArch(this.osArch);
        String detectedClassifier = detectedName + '-' + detectedArch;
        this.setProperty("os.detected.name", detectedName);
        this.setProperty("os.detected.arch", detectedArch);
        this.setProperty("os.detected.classifier", detectedClassifier);
        if (this.failOnUnknownOS) {
            if (UNKNOWN.equals(detectedName)) {
                throw new MojoExecutionException("unknown os.name: " + this.osName);
            }
            if (UNKNOWN.equals(detectedArch)) {
                throw new MojoExecutionException("unknown os.arch: " + this.osArch);
            }
        }
    }

    private void setProperty(String name, String value) {
        Log log = this.getLog();
        Properties props = this.project.getProperties();
        props.setProperty(name, value);
        System.setProperty(name, value);
        if (log.isInfoEnabled()) {
            log.info((CharSequence)(name + ": " + value));
        }
    }

    private static String normalizeOs(String value) {
        if ((value = DetectMojo.normalize(value)).startsWith("aix")) {
            return "aix";
        }
        if (value.startsWith("hpux")) {
            return "hpux";
        }
        if (value.startsWith("os400") && (value.length() <= 5 || !Character.isDigit(value.charAt(5)))) {
            return "os400";
        }
        if (value.startsWith("linux")) {
            return "linux";
        }
        if (value.startsWith("macosx")) {
            return "osx";
        }
        if (value.startsWith("freebsd")) {
            return "freebsd";
        }
        if (value.startsWith("openbsd")) {
            return "openbsd";
        }
        if (value.startsWith("netbsd")) {
            return "netbsd";
        }
        if (value.startsWith("solaris") || value.startsWith("sunos")) {
            return "sunos";
        }
        if (value.startsWith("windows")) {
            return "windows";
        }
        return UNKNOWN;
    }

    private static String normalizeArch(String value) {
        if ((value = DetectMojo.normalize(value)).matches("^(amd64|ia32e|em64t|x64)$")) {
            return "x86_64";
        }
        if (value.matches("^(i[3-6]86|ia32|x32)$")) {
            return "x86_32";
        }
        if (value.equals("ia64")) {
            return "itanium_64";
        }
        if (value.equals("sparc")) {
            return "sparc_32";
        }
        if (value.equals("sparcv9")) {
            return "sparc_64";
        }
        if (value.equals("arm")) {
            return "arm_32";
        }
        if (value.equals("aarch64")) {
            return "aarch_64";
        }
        if (value.equals("ppc")) {
            return "ppc_32";
        }
        if (value.equals("ppc64")) {
            return "ppc_64";
        }
        return UNKNOWN;
    }

    private static String normalize(String value) {
        if (value == null) {
            return "";
        }
        return value.toLowerCase(Locale.US).replaceAll("[^a-z0-9]+", "");
    }
}

