/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.sf.proj;

import java.util.HashMap;
import java.util.Map;
import mil.nga.sf.proj.AuthorityProjections;
import mil.nga.sf.proj.Projection;

public class Projections {
    private Map<String, AuthorityProjections> authorities = new HashMap<String, AuthorityProjections>();

    public AuthorityProjections getProjections(String authority) {
        return this.authorities.get(authority.toUpperCase());
    }

    public Projection getProjection(String authority, String code) {
        Projection projection = null;
        AuthorityProjections authorityProjections = this.getProjections(authority);
        if (authorityProjections != null) {
            projection = authorityProjections.getProjection(code);
        }
        return projection;
    }

    public boolean hasProjection(Projection projection) {
        return this.hasProjection(projection.getAuthority(), projection.getCode());
    }

    public boolean hasProjection(String authority, String code) {
        return this.getProjection(authority, code) != null;
    }

    public void addProjection(Projection projection) {
        String authority = projection.getAuthority();
        AuthorityProjections authorityProjections = this.getProjections(authority);
        if (authorityProjections == null) {
            authorityProjections = new AuthorityProjections(authority.toUpperCase());
            this.authorities.put(authorityProjections.getAuthority(), authorityProjections);
        }
        authorityProjections.addProjection(projection);
    }

    public void clear() {
        this.authorities.clear();
    }

    public void clear(String authority) {
        this.authorities.remove(authority.toUpperCase());
    }

    public void remove(String authority, long code) {
        this.remove(authority, String.valueOf(code));
    }

    public void remove(String authority, String code) {
        AuthorityProjections authorityProjections = this.getProjections(authority);
        if (authorityProjections != null) {
            authorityProjections.remove(code);
            if (authorityProjections.isEmpty()) {
                this.clear(authority);
            }
        }
    }

    public void remove(Projection projection) {
        this.remove(projection.getAuthority(), projection.getCode());
    }

    public int authorityCount() {
        return this.authorities.size();
    }

    public int projectionCount() {
        int count = 0;
        for (AuthorityProjections authorityProjections : this.authorities.values()) {
            count += authorityProjections.count();
        }
        return count;
    }

    public boolean isEmpty() {
        return this.authorities.isEmpty();
    }
}

