/*
 * Decompiled with CFR 0.152.
 */
package scala_maven_executions;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.maven.plugin.MojoFailureException;
import scala_maven_executions.ForkMain;

public final class Fork {
    private static final boolean IS_WINDOWS = System.getProperty("os.name").toLowerCase(Locale.ROOT).startsWith("windows");
    private static final String BOOTER_JAR_NAME = "scala-maven-plugin-booter";
    private final File javaExecutable;
    private final String mainClassName;
    private final List<String> classpath;
    private final String[] jvmArgs;
    private final String[] args;

    public Fork(String mainClassName, List<String> classpath, String[] jvmArgs, String[] args, File javaExecutable) {
        this.mainClassName = mainClassName;
        this.classpath = classpath;
        this.jvmArgs = jvmArgs;
        this.args = args;
        this.javaExecutable = javaExecutable;
    }

    private static String toWindowsShortName(String value) {
        int programFilesIndex;
        if (IS_WINDOWS && (programFilesIndex = value.indexOf("Program Files")) >= 0) {
            int firstSeparatorAfterProgramFiles = value.indexOf(File.separator, programFilesIndex + "Program Files".length());
            File longNameDir = firstSeparatorAfterProgramFiles < 0 ? new File(value) : new File(value.substring(0, firstSeparatorAfterProgramFiles));
            for (int i = 0; i < 10; ++i) {
                File shortNameDir = new File(longNameDir.getParent(), "Progra~" + i);
                if (!shortNameDir.equals(longNameDir)) continue;
                return shortNameDir.toString();
            }
        }
        return value;
    }

    public void run(OutputStream os) throws Exception {
        File booterJar = Fork.createBooterJar(this.classpath, ForkMain.class.getName(), this.args);
        CommandLine command = new CommandLine(Fork.toWindowsShortName(this.javaExecutable.getCanonicalPath()));
        command.addArguments(this.jvmArgs, false);
        command.addArgument("-jar");
        command.addArgument(booterJar.getCanonicalPath());
        command.addArgument(this.mainClassName);
        DefaultExecutor exec = new DefaultExecutor();
        exec.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler(os));
        int exitValue = exec.execute(command);
        if (exitValue != 0) {
            throw new MojoFailureException("command line returned non-zero value:" + exitValue);
        }
    }

    private static File createBooterJar(List<String> classPath, String startClassName, String[] args) throws IOException {
        File file = File.createTempFile(BOOTER_JAR_NAME, ".jar");
        file.deleteOnExit();
        String cp = classPath.stream().map(element -> Fork.getURL(new File((String)element)).toExternalForm()).collect(Collectors.joining(" "));
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
        manifest.getMainAttributes().putValue(Attributes.Name.MAIN_CLASS.toString(), startClassName);
        manifest.getMainAttributes().putValue(Attributes.Name.CLASS_PATH.toString(), cp);
        try (JarOutputStream jos = new JarOutputStream(new BufferedOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0])));){
            jos.setLevel(0);
            JarEntry manifestJarEntry = new JarEntry("META-INF/MANIFEST.MF");
            jos.putNextEntry(manifestJarEntry);
            manifest.write(jos);
            jos.closeEntry();
            JarEntry argsJarEntry = new JarEntry("META-INF/args.txt");
            jos.putNextEntry(argsJarEntry);
            jos.write(Arrays.stream(args).collect(Collectors.joining("\n")).getBytes(StandardCharsets.UTF_8));
            jos.closeEntry();
        }
        return file;
    }

    private static URL getURL(File file) {
        try {
            return new URL(file.toURI().toASCIIString());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

