/*
 * Decompiled with CFR 0.152.
 */
package scala_maven_executions;

import java.util.regex.Pattern;

public class LogProcessorUtils {
    private static final Pattern WARNING_WORD = Pattern.compile("\\bwarnings?\\b(?!\\.scala)");
    private static final Pattern ERROR_WORD = Pattern.compile("\\berrors?\\b(?!\\.scala)");

    public static LevelState levelStateOf(String line, LevelState previous) {
        LevelState back = new LevelState();
        String lineLowerCase = line.toLowerCase();
        if (LogProcessorUtils.isWarningLine(lineLowerCase)) {
            back.level = Level.WARNING;
            if (lineLowerCase.contains(".scala")) {
                back.untilContains = "^";
            }
        } else if (LogProcessorUtils.isErrorLine(lineLowerCase)) {
            back.level = Level.ERROR;
            if (lineLowerCase.contains(".scala")) {
                back.untilContains = "^";
            }
        } else if (previous.untilContains != null) {
            if (!lineLowerCase.contains(previous.untilContains)) {
                back = previous;
            } else {
                back.level = previous.level;
                back.untilContains = null;
            }
        }
        return back;
    }

    private static boolean isWarningLine(String line) {
        return LogProcessorUtils.hasSeverityMarker(line, "warning") || WARNING_WORD.matcher(line).find();
    }

    private static boolean isErrorLine(String line) {
        return LogProcessorUtils.hasSeverityMarker(line, "error") || ERROR_WORD.matcher(line).find();
    }

    private static boolean hasSeverityMarker(String lineLowerCase, String marker) {
        return lineLowerCase.startsWith(marker + ":") || lineLowerCase.contains(" " + marker + ":");
    }

    public static class LevelState {
        public Level level = Level.INFO;
        public String untilContains = null;
    }

    public static enum Level {
        ERROR,
        WARNING,
        INFO;

    }
}

