/*
 * Decompiled with CFR 0.152.
 */
package com.kscs.util.plugins.xjc.base;

import com.kscs.util.plugins.xjc.base.ResourceDirectory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Logger;
import sun.util.ResourceBundleEnumeration;

public class PropertyDirectoryResourceBundle
extends ResourceBundle {
    private static final Logger LOGGER = Logger.getLogger(PropertyDirectoryResourceBundle.class.getName());
    private final Map<String, String> values;

    public static ResourceBundle getInstance(String baseName) {
        return PropertyDirectoryResourceBundle.getBundle(baseName, Control.INSTANCE);
    }

    public static ResourceBundle getInstance(String baseName, Locale locale) {
        return PropertyDirectoryResourceBundle.getBundle(baseName, locale, Control.INSTANCE);
    }

    public static ResourceBundle getInstance(Class<?> localizedClass) {
        return PropertyDirectoryResourceBundle.getBundle(localizedClass.getName(), Control.INSTANCE);
    }

    public static ResourceBundle getInstance(Class<?> localizedClass, Locale locale) {
        return PropertyDirectoryResourceBundle.getBundle(localizedClass.getName(), locale, Control.INSTANCE);
    }

    public PropertyDirectoryResourceBundle(Map<String, String> values) {
        this.values = values;
    }

    @Override
    protected Object handleGetObject(String key) {
        return this.values.get(key);
    }

    @Override
    public Enumeration<String> getKeys() {
        ResourceBundle parent = this.parent;
        return new ResourceBundleEnumeration(this.values.keySet(), parent != null ? parent.getKeys() : null);
    }

    @Override
    protected Set<String> handleKeySet() {
        return this.values.keySet();
    }

    public static class Control
    extends ResourceBundle.Control {
        public static final Control INSTANCE = new Control();
        final Map<String, PropertyDirectoryResourceBundle> cachedBundles = new HashMap<String, PropertyDirectoryResourceBundle>();

        private Control() {
        }

        @Override
        public List<String> getFormats(String baseName) {
            ArrayList<String> formats = new ArrayList<String>();
            formats.add("text");
            formats.addAll(super.getFormats(baseName));
            return Collections.unmodifiableList(formats);
        }

        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            if ("text".equals(format)) {
                String bundleLocalizedName = this.toBundleName(baseName, locale);
                if (!reload && this.cachedBundles.containsKey(bundleLocalizedName)) {
                    return this.cachedBundles.get(bundleLocalizedName);
                }
                String bundleIndexPath = baseName.replace('.', '/') + ".index";
                Properties bundleIndex = new Properties();
                InputStream inputStream = loader.getResourceAsStream(bundleIndexPath);
                if (inputStream != null) {
                    LOGGER.finer("Loading text file resource index: " + bundleIndexPath);
                    bundleIndex.load(inputStream);
                }
                String bundleResourcePath = bundleLocalizedName.replace('.', '/');
                Path dirPath = ResourceDirectory.fromResource(loader, bundleResourcePath);
                LOGGER.finer("Resolved directory path: " + dirPath);
                if (dirPath == null) {
                    return super.newBundle(baseName, locale, format, loader, reload);
                }
                DirectoryStream<Path> directoryStream = Files.newDirectoryStream(dirPath);
                Object object = null;
                try {
                    for (Path filePath : directoryStream) {
                        if (bundleIndex.containsValue(filePath.getFileName().toString())) continue;
                        String fileName = filePath.getFileName().toString();
                        bundleIndex.setProperty(fileName.substring(0, fileName.lastIndexOf(46)), fileName);
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (directoryStream != null) {
                        if (object != null) {
                            try {
                                directoryStream.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            directoryStream.close();
                        }
                    }
                }
                HashMap<String, String> values = new HashMap<String, String>();
                for (Object e : bundleIndex.keySet()) {
                    String propertyValue = bundleIndex.getProperty(e.toString());
                    String textFileName = propertyValue == null || propertyValue.trim().length() == 0 ? e.toString() : propertyValue;
                    Path textFilePath = Paths.get(bundleResourcePath, textFileName);
                    try {
                        LOGGER.finest("Loading resource text file \"" + textFilePath + "\"");
                        URL textFileURL = loader.getResource(textFilePath.toString());
                        LOGGER.finest("Resource text file \"" + textFilePath + "\" URL: " + textFileURL);
                        StringBuilder sb = new StringBuilder();
                        try (BufferedReader reader = new BufferedReader(new InputStreamReader(loader.getResourceAsStream(textFilePath.toString()), Charset.forName("UTF-8")));){
                            String line;
                            while ((line = reader.readLine()) != null) {
                                sb.append(line);
                                sb.append("\n");
                            }
                        }
                        LOGGER.finest("Text file \"" + textFilePath + "\" loaded.");
                        values.put(e.toString(), sb.toString());
                    }
                    catch (Exception e2) {
                        return super.newBundle(baseName, locale, format, loader, reload);
                    }
                }
                PropertyDirectoryResourceBundle bundle = new PropertyDirectoryResourceBundle(values);
                bundle.setParent(super.newBundle(baseName, locale, "java.properties", loader, reload));
                this.cachedBundles.put(bundleLocalizedName, bundle);
                return bundle;
            }
            return super.newBundle(baseName, locale, format, loader, reload);
        }
    }
}

