/*
 * Decompiled with CFR 0.152.
 */
package net.corda.plugins.apiscanner;

import io.github.classgraph.AnnotationInfoList;
import io.github.classgraph.BaseTypeSignature;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ClassRefTypeSignature;
import io.github.classgraph.FieldInfo;
import io.github.classgraph.MethodInfo;
import io.github.classgraph.MethodParameterInfo;
import io.github.classgraph.TypeSignature;
import io.github.classgraph.TypeVariableSignature;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import nonapi.io.github.classgraph.types.TypeUtils;

class ApiPrintWriter
extends PrintWriter {
    private static final int METHOD_MASK = Modifier.methodModifiers() | 0x80;

    ApiPrintWriter(File file, String encoding) throws FileNotFoundException, UnsupportedEncodingException {
        super(file, encoding);
    }

    void println(@Nonnull ClassInfo classInfo, int modifierMask, List<String> filteredAnnotations) {
        this.append(ApiPrintWriter.asAnnotations(filteredAnnotations, ""));
        this.append(Modifier.toString(classInfo.loadClass().getModifiers() & modifierMask));
        if (classInfo.isAnnotation()) {
            this.append(" @interface ").print(classInfo.getName());
        } else if (classInfo.isStandardClass()) {
            this.append(" class ").print(classInfo.getName());
            this.append(" extends ");
            ClassInfo superclass = classInfo.getSuperclass();
            this.print(superclass == null ? "java.lang.Object" : superclass.getName());
            ClassInfoList interfaces = classInfo.getInterfaces().getImplementedInterfaces().directOnly();
            if (!interfaces.isEmpty()) {
                this.append(" implements ").print(ApiPrintWriter.stringOf((Collection<ClassInfo>)interfaces));
            }
        } else {
            this.append(" interface ").print(classInfo.getName());
            ClassInfoList superinterfaces = classInfo.getInterfaces().directOnly();
            if (!superinterfaces.isEmpty()) {
                this.append(" extends ").print(ApiPrintWriter.stringOf((Collection<ClassInfo>)superinterfaces));
            }
        }
        this.println();
    }

    void println(@Nonnull MethodInfo method, @Nonnull AnnotationInfoList visibleAnnotations, String indentation) {
        this.append(ApiPrintWriter.asAnnotations(visibleAnnotations.getNames(), indentation));
        this.append(indentation).append(ApiPrintWriter.pureModifiersFor(method)).append(' ');
        if (!method.isConstructor()) {
            this.append(ApiPrintWriter.removeQualifierFromBaseTypes(method.getTypeSignatureOrTypeDescriptor().getResultType())).append(' ');
        }
        this.append(method.getName()).append('(');
        LinkedList paramTypes = Arrays.stream(method.getParameterInfo()).map(MethodParameterInfo::getTypeSignatureOrTypeDescriptor).map(ApiPrintWriter::removeQualifierFromBaseTypes).collect(Collectors.toCollection(LinkedList::new));
        if (method.isVarArgs() && !paramTypes.isEmpty()) {
            String vararg = (String)paramTypes.removeLast();
            paramTypes.add(vararg.substring(0, vararg.length() - 2) + "...");
        }
        this.append(String.join((CharSequence)", ", paramTypes));
        this.println(')');
    }

    void println(@Nonnull FieldInfo field, @Nonnull AnnotationInfoList visibleAnnotations, String indentation) {
        this.append(ApiPrintWriter.asAnnotations(visibleAnnotations.getNames(), indentation)).append(indentation).append(field.getModifiersStr()).append(' ').append(ApiPrintWriter.removeQualifierFromBaseTypes(field.getTypeSignatureOrTypeDescriptor())).append(' ').append(field.getName());
        Object constantInitializer = field.getConstantInitializerValue();
        if (constantInitializer != null) {
            this.append(" = ");
            if (constantInitializer instanceof String) {
                this.append('\"').append(constantInitializer.toString()).append('\"');
            } else if (constantInitializer instanceof Character) {
                this.append('\'').append(constantInitializer.toString()).append('\'');
            } else {
                this.append(constantInitializer.toString());
            }
        }
        this.println();
    }

    private static String asAnnotations(@Nonnull Collection<String> items, String indentation) {
        if (items.isEmpty()) {
            return "";
        }
        return items.stream().map(ApiPrintWriter::removePackageName).collect(Collectors.joining(System.lineSeparator() + indentation + '@', indentation + '@', System.lineSeparator()));
    }

    @Nonnull
    private static String pureModifiersFor(@Nonnull MethodInfo method) {
        StringBuilder builder = new StringBuilder();
        TypeUtils.modifiersToString((int)(method.getModifiers() & METHOD_MASK), (TypeUtils.ModifierType)TypeUtils.ModifierType.METHOD, (boolean)false, (StringBuilder)builder);
        return builder.toString();
    }

    @Nonnull
    private static String removePackageName(@Nonnull String className) {
        return className.substring(className.lastIndexOf(46) + 1);
    }

    private static String stringOf(@Nonnull Collection<ClassInfo> items) {
        return items.stream().map(ClassInfo::getName).sorted().collect(Collectors.joining(", "));
    }

    private static String stringOf(TypeSignature sig) {
        if (sig instanceof BaseTypeSignature) {
            return ((BaseTypeSignature)sig).getTypeStr();
        }
        if (sig instanceof ClassRefTypeSignature) {
            return ((ClassRefTypeSignature)sig).getFullyQualifiedClassName();
        }
        if (sig instanceof TypeVariableSignature) {
            return ((TypeVariableSignature)sig).getName();
        }
        return sig.toString();
    }

    @Nonnull
    private static String removeQualifierFromBaseTypes(@Nonnull String className) {
        return className.replace("java.lang.", "");
    }

    @Nonnull
    private static String removeQualifierFromBaseTypes(TypeSignature typeSignature) {
        return ApiPrintWriter.removeQualifierFromBaseTypes(ApiPrintWriter.stringOf(typeSignature));
    }
}

