/*
 * Decompiled with CFR 0.152.
 */
package net.corda.plugins.apiscanner;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import net.corda.plugins.apiscanner.GenerateApi;
import net.corda.plugins.apiscanner.ScanApi;
import net.corda.plugins.apiscanner.ScannerExtension;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.AbstractTask;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.jvm.tasks.Jar;
import org.gradle.util.GradleVersion;

public class ApiScanner
implements Plugin<Project> {
    private static final String CLASSIFIER_PROPERTY_NAME = "cordaScanApiClassifier";
    private static final String DEFAULT_CLASSIFIER = "";
    private static final String SCAN_TASK_NAME = "scanApi";
    private static final String MINIMUM_GRADLE_VERSION = "7.2";
    static final String GROUP_NAME = "Corda API";

    public void apply(@Nonnull Project project) {
        project.getLogger().info("Applying API scanner to {}", (Object)project.getName());
        if (GradleVersion.current().compareTo(GradleVersion.version((String)MINIMUM_GRADLE_VERSION)) < 0) {
            throw new GradleException("The API Scanner plugin requires Gradle 7.2 or newer.");
        }
        project.getPluginManager().apply(JavaPlugin.class);
        Object classifierValue = project.findProperty(CLASSIFIER_PROPERTY_NAME);
        String targetClassifier = classifierValue == null ? DEFAULT_CLASSIFIER : classifierValue.toString();
        ScannerExtension extension = (ScannerExtension)project.getExtensions().create(SCAN_TASK_NAME, ScannerExtension.class, new Object[]{targetClassifier});
        project.getLogger().info("Adding {} task to {}", (Object)SCAN_TASK_NAME, (Object)project.getName());
        TaskProvider scanProvider = project.getTasks().register(SCAN_TASK_NAME, ScanApi.class, scanTask -> {
            TaskCollection jarTasks = project.getTasks().withType(Jar.class).matching(AbstractTask::isEnabled).matching(jarTask -> ApiScanner.matches((Provider<String>)jarTask.getArchiveClassifier(), extension.getTargetClassifier()));
            scanTask.setClasspath((FileCollection)project.getConfigurations().getByName("compileClasspath"));
            scanTask.setSources(jarTasks);
            scanTask.setExcludePackages((Provider<? extends Set<String>>)extension.getExcludePackages());
            scanTask.setExcludeClasses((Provider<? extends Set<String>>)extension.getExcludeClasses());
            scanTask.setExcludeMethods((Provider<? extends Map<String, ? extends Collection>>)extension.getExcludeMethods());
            scanTask.setVerbose((Provider<Boolean>)extension.getVerbose());
            scanTask.setEnabled(extension.isEnabled());
        });
        for (Project target = project; target != null; target = target.getParent()) {
            target.getTasks().withType(GenerateApi.class).configureEach(generateTask -> generateTask.dependsOn(new Object[]{scanProvider}));
        }
    }

    private static boolean matches(@Nonnull Provider<String> a, @Nonnull Provider<String> b) {
        return Objects.equals(a.getOrNull(), b.getOrNull());
    }
}

