/*
 * Decompiled with CFR 0.152.
 */
package net.corda.plugins.apiscanner;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.corda.plugins.apiscanner.ScanApi;
import org.gradle.api.DefaultTask;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.AbstractTask;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault
public class GenerateApi
extends DefaultTask {
    private final Property<String> baseName;
    private final Property<String> version;
    private final Provider<RegularFile> target;
    private final ConfigurableFileCollection sources;

    public GenerateApi() {
        this.setGroup("Corda API");
        this.setDescription("Aggregates API scan results found in any sub-projects into a single output.");
        Project project = this.getProject();
        ObjectFactory objects = project.getObjects();
        this.baseName = objects.property(String.class).convention((Object)("api-" + project.getName()));
        this.version = objects.property(String.class).convention((Object)project.getVersion().toString());
        DirectoryProperty outputDir = objects.directoryProperty().convention(project.getLayout().getBuildDirectory().dir("api"));
        this.target = outputDir.file(this.version.flatMap(v -> this.baseName.map(n -> GenerateApi.createFileName(n, v))));
        this.sources = project.files(new Object[]{project.provider(() -> project.getAllprojects().stream().flatMap(p -> p.getTasks().withType(ScanApi.class).matching(AbstractTask::isEnabled).stream()).map(ScanApi::getTargets).collect(Collectors.toList()))});
        this.sources.disallowChanges();
    }

    @Nonnull
    private static String createFileName(String baseName, @Nonnull String version) {
        StringBuilder builder = new StringBuilder(baseName);
        if (!version.isEmpty()) {
            builder.append('-').append(version);
        }
        return builder.append(".txt").toString();
    }

    @Input
    public Property<String> getBaseName() {
        return this.baseName;
    }

    @Input
    public Property<String> getVersion() {
        return this.version;
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    public FileCollection getSources() {
        return this.sources;
    }

    @OutputFile
    public Provider<RegularFile> getTarget() {
        return this.target;
    }

    @TaskAction
    public void generate() {
        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(((RegularFile)this.target.get()).getAsFile()));){
            for (File apiFile : this.getApiFiles()) {
                Files.copy(apiFile.toPath(), output);
            }
        }
        catch (IOException e) {
            this.getLogger().error("Failed to generate API file: {}", (Object)e.getMessage());
            throw new InvalidUserCodeException(e.getMessage(), (Throwable)e);
        }
    }

    @Nonnull
    private List<File> getApiFiles() {
        ArrayList<File> apiFiles = new ArrayList<File>(this.sources.getFiles());
        apiFiles.sort(Comparator.comparing(File::getName));
        return apiFiles;
    }
}

