/*
 * Decompiled with CFR 0.152.
 */
package net.corda.plugins.apiscanner;

import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.AnnotationInfoList;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.FieldInfo;
import io.github.classgraph.MethodInfo;
import io.github.classgraph.ScanResult;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import net.corda.plugins.apiscanner.ApiPrintWriter;
import net.corda.plugins.apiscanner.Names;
import org.gradle.api.DefaultTask;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.Console;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault
class ScanApi
extends DefaultTask {
    private static final int CLASS_MASK = Modifier.classModifiers();
    private static final int INTERFACE_MASK = Modifier.interfaceModifiers() & 0xFFFFFBFF;
    private static final int METHOD_MASK = Modifier.methodModifiers() | 0x80 | 0x1000;
    private static final int FIELD_MASK = Modifier.fieldModifiers();
    private static final int VISIBILITY_MASK = 5;
    private static final String ENUM_BASE_CLASS = "java.lang.Enum";
    private static final String DONOTIMPLEMENT_ANNOTATION_NAME = "net.corda.v5.base.annotations.DoNotImplement";
    private static final String INTERNAL_ANNOTATION_NAME = ".CordaInternal";
    private static final String DEFAULT_INTERNAL_ANNOTATION = "net.corda.v5.base.annotations.CordaInternal";
    private static final Set<String> ANNOTATION_BLACKLIST;
    private static final String KOTLIN_METADATA = "kotlin.Metadata";
    private static final String KOTLIN_CLASSTYPE_METHOD = "k";
    private static final int KOTLIN_SYNTHETIC = 3;
    private final ConfigurableFileCollection sources;
    private final ConfigurableFileCollection classpath;
    private final Provider<Set<FileSystemLocation>> targets;
    private final SetProperty<String> excludePackages;
    private final SetProperty<String> excludeClasses;
    private final MapProperty<String, Set> excludeMethods;
    private final Provider<Directory> outputDir;
    private final Property<Boolean> verbose;

    @Inject
    public ScanApi(@Nonnull ObjectFactory objects, @Nonnull ProjectLayout layout) {
        this.sources = objects.fileCollection();
        this.classpath = objects.fileCollection();
        this.excludePackages = objects.setProperty(String.class);
        this.excludeClasses = objects.setProperty(String.class);
        this.excludeMethods = objects.mapProperty(String.class, Set.class);
        this.verbose = objects.property(Boolean.class).convention((Object)false);
        this.outputDir = layout.getBuildDirectory().dir("api");
        this.targets = this.outputDir.flatMap(dir -> this.sources.getElements().map(files -> files.stream().map(file -> ScanApi.toTarget(dir, file)).collect(Collectors.toSet())));
        this.setDescription("Summarises the target JAR's public and protected API elements.");
        this.setGroup("Corda API");
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @SkipWhenEmpty
    @InputFiles
    public FileCollection getSources() {
        return this.sources;
    }

    void setSources(Object ... sources) {
        this.sources.setFrom(sources);
        this.sources.disallowChanges();
    }

    @CompileClasspath
    @InputFiles
    public FileCollection getClasspath() {
        return this.classpath;
    }

    void setClasspath(FileCollection classpath) {
        this.classpath.setFrom((Iterable)classpath);
        this.classpath.disallowChanges();
    }

    @Input
    public Provider<? extends Set<String>> getExcludePackages() {
        return this.excludePackages;
    }

    void setExcludePackages(Provider<? extends Set<String>> excludePackages) {
        this.excludePackages.set(excludePackages);
    }

    @Input
    public Provider<? extends Set<String>> getExcludeClasses() {
        return this.excludeClasses;
    }

    void setExcludeClasses(Provider<? extends Set<String>> excludeClasses) {
        this.excludeClasses.set(excludeClasses);
    }

    @Input
    public Provider<? extends Map<String, ? extends Set>> getExcludeMethods() {
        return this.excludeMethods;
    }

    void setExcludeMethods(@Nonnull Provider<? extends Map<String, ? extends Collection>> excludeMethods) {
        this.excludeMethods.empty().putAll(excludeMethods.map(m -> {
            LinkedHashMap result = new LinkedHashMap();
            m.forEach((key, value) -> {
                Set cfr_ignored_0 = result.put(key, new LinkedHashSet(value));
            });
            return result;
        }));
    }

    @OutputFiles
    public Provider<Set<FileSystemLocation>> getTargets() {
        return this.targets;
    }

    @Console
    public Provider<Boolean> getVerbose() {
        return this.verbose;
    }

    void setVerbose(Provider<Boolean> verbose) {
        this.verbose.set(verbose);
    }

    @Nonnull
    private static RegularFile toTargetFile(@Nonnull Directory outputDir, @Nonnull File source) {
        return outputDir.file(source.getName().replaceAll("\\.jar$", ".txt"));
    }

    @Nonnull
    private static RegularFile toTarget(Directory outputDir, @Nonnull FileSystemLocation source) {
        return ScanApi.toTargetFile(outputDir, source.getAsFile());
    }

    @TaskAction
    public void scan() {
        try (Scanner scanner = new Scanner((FileCollection)this.classpath);){
            for (File source : this.sources) {
                scanner.scan(source);
            }
        }
        catch (IOException e) {
            this.getLogger().error("Failed to write API file", (Throwable)e);
            throw new InvalidUserCodeException(e.getMessage(), (Throwable)e);
        }
    }

    private static <T extends Comparable<? super T>> List<T> ordering(List<T> list) {
        Collections.sort(list);
        return list;
    }

    private static boolean isKotlinInternalScope(@Nonnull MethodInfo method) {
        return method.getName().indexOf(36) >= 0;
    }

    private static boolean isEnumConstructor(@Nonnull MethodInfo method) {
        return method.isConstructor() && method.getClassInfo().extendsSuperclass(ENUM_BASE_CLASS);
    }

    private static boolean isValid(int modifiers, int mask) {
        return (modifiers & mask) == modifiers;
    }

    private boolean isExcluded(@Nonnull MethodInfo method) {
        String methodSignature = method.getName() + method.getTypeDescriptorStr();
        String className = method.getClassInfo().getName();
        Provider excluded = this.excludeMethods.getting((Object)className);
        return excluded.isPresent() && ((Set)excluded.get()).contains(methodSignature);
    }

    private static boolean isVisible(int accessFlags) {
        return (accessFlags & 5) != 0;
    }

    private static boolean isApplicationClass(@Nonnull String typeName) {
        return !typeName.startsWith("java.") && !typeName.startsWith("kotlin.");
    }

    @Nonnull
    private static URL toURL(@Nonnull File file) throws MalformedURLException {
        return file.toURI().toURL();
    }

    @Nonnull
    private static URL[] toURLs(@Nonnull Iterable<File> files) throws MalformedURLException {
        LinkedList<URL> urls = new LinkedList<URL>();
        for (File file : files) {
            urls.add(ScanApi.toURL(file));
        }
        return urls.toArray(new URL[0]);
    }

    static {
        LinkedHashSet<String> blacklist = new LinkedHashSet<String>();
        blacklist.add("kotlin.jvm.JvmField");
        blacklist.add("kotlin.jvm.JvmOverloads");
        blacklist.add("kotlin.jvm.JvmStatic");
        blacklist.add("kotlin.jvm.JvmDefault");
        blacklist.add("kotlin.Deprecated");
        blacklist.add("java.lang.Deprecated");
        blacklist.add(DEFAULT_INTERNAL_ANNOTATION);
        ANNOTATION_BLACKLIST = Collections.unmodifiableSet(blacklist);
    }

    class Scanner
    implements Closeable {
        private final URLClassLoader classpathLoader;
        private final Class<? extends Annotation> metadataClass;
        private final Method classTypeMethod;
        private Collection<String> internalAnnotations;
        private Collection<String> invisibleAnnotations;
        private Collection<String> inheritedAnnotations;

        Scanner(URLClassLoader classpathLoader) {
            Method kMethod;
            Class<?> kClass;
            this.classpathLoader = classpathLoader;
            this.invisibleAnnotations = ANNOTATION_BLACKLIST;
            this.inheritedAnnotations = Collections.emptySet();
            this.internalAnnotations = Collections.emptySet();
            try {
                kClass = Class.forName(ScanApi.KOTLIN_METADATA, true, classpathLoader);
                kMethod = kClass.getDeclaredMethod(ScanApi.KOTLIN_CLASSTYPE_METHOD, new Class[0]);
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                kClass = null;
                kMethod = null;
            }
            this.metadataClass = kClass;
            this.classTypeMethod = kMethod;
        }

        Scanner(FileCollection classpath) throws MalformedURLException {
            this(new URLClassLoader(ScanApi.toURLs((Iterable)classpath)));
        }

        @Override
        public void close() throws IOException {
            this.classpathLoader.close();
        }

        void scan(File source) {
            File target = ((RegularFile)ScanApi.this.outputDir.map(dir -> ScanApi.toTargetFile(dir, source)).get()).getAsFile();
            ScanApi.this.getLogger().info("API file: {}", (Object)target.getAbsolutePath());
            try (URLClassLoader appLoader = new URLClassLoader(new URL[]{ScanApi.toURL(source)}, (ClassLoader)this.classpathLoader);
                 ApiPrintWriter writer = new ApiPrintWriter(target, "UTF-8");){
                this.scan(writer, appLoader);
            }
            catch (IOException e) {
                ScanApi.this.getLogger().error("API scan has failed", (Throwable)e);
                throw new InvalidUserCodeException(e.getMessage(), (Throwable)e);
            }
        }

        void scan(ApiPrintWriter writer, ClassLoader appLoader) {
            try (ScanResult result = new ClassGraph().rejectPackages(((Set)ScanApi.this.excludePackages.get()).toArray(new String[0])).rejectClasses(((Set)ScanApi.this.excludeClasses.get()).toArray(new String[0])).overrideClassLoaders(new ClassLoader[]{appLoader}).ignoreParentClassLoaders().ignoreMethodVisibility().ignoreFieldVisibility().disableDirScanning().enableStaticFinalFieldConstantInitializerValues().enableExternalClasses().enableAnnotationInfo().enableClassInfo().enableMethodInfo().enableFieldInfo().verbose(((Boolean)ScanApi.this.verbose.get()).booleanValue()).scan();){
                this.loadAnnotationCaches(result);
                ScanApi.this.getLogger().info("Annotations:");
                ScanApi.this.getLogger().info("- Inherited: {}", this.inheritedAnnotations);
                ScanApi.this.getLogger().info("- Internal:  {}", this.internalAnnotations);
                ScanApi.this.getLogger().info("- Invisible: {}", this.invisibleAnnotations);
                this.writeApis(writer, result);
            }
        }

        private void loadAnnotationCaches(@Nonnull ScanResult result) {
            ClassInfoList scannedAnnotations = result.getAllAnnotations();
            Set internal = scannedAnnotations.getNames().stream().filter(s -> s.endsWith(ScanApi.INTERNAL_ANNOTATION_NAME)).collect(Collectors.toCollection(LinkedHashSet::new));
            internal.add(ScanApi.DEFAULT_INTERNAL_ANNOTATION);
            this.internalAnnotations = Collections.unmodifiableSet(internal);
            Set invisible = this.internalAnnotations.stream().flatMap(a -> scannedAnnotations.filter(i -> i.hasAnnotation(a)).getNames().stream()).collect(Collectors.toCollection(LinkedHashSet::new));
            invisible.addAll(ANNOTATION_BLACKLIST);
            invisible.addAll(internal);
            this.invisibleAnnotations = Collections.unmodifiableSet(invisible);
            List inherited = scannedAnnotations.filter(a -> a.loadClass().isAnnotationPresent(Inherited.class)).getNames();
            this.inheritedAnnotations = Collections.unmodifiableSet(new LinkedHashSet(inherited));
        }

        private void writeApis(ApiPrintWriter writer, @Nonnull ScanResult result) {
            Map allInfo = result.getAllClassesAsMap();
            result.getAllClasses().getNames().forEach(className -> {
                if (className.contains(".internal.")) {
                    return;
                }
                ClassInfo classInfo = (ClassInfo)allInfo.get(className);
                if (classInfo.isExternalClass()) {
                    return;
                }
                if (classInfo.isAnnotation() && !this.isVisibleAnnotation((String)className)) {
                    return;
                }
                if (this.hasInternalAnnotation(classInfo.getAnnotations().directOnly().getNames())) {
                    return;
                }
                Class javaClass = result.loadClass(className, false);
                if (!ScanApi.isVisible(javaClass.getModifiers())) {
                    return;
                }
                if (classInfo.getFullyQualifiedDefiningMethodName() != null) {
                    return;
                }
                int kotlinClassType = this.getKotlinClassType(javaClass);
                if (kotlinClassType == 3) {
                    return;
                }
                this.writeClass(writer, classInfo);
                this.writeMethods(writer, (List<MethodInfo>)classInfo.getDeclaredMethodAndConstructorInfo());
                this.writeFields(writer, (List<FieldInfo>)classInfo.getDeclaredFieldInfo());
                writer.println("##");
            });
        }

        private void writeClass(ApiPrintWriter writer, @Nonnull ClassInfo classInfo) {
            if (classInfo.isAnnotation()) {
                writer.println(classInfo, INTERFACE_MASK, Collections.emptyList());
            } else if (classInfo.isStandardClass()) {
                writer.println(classInfo, CLASS_MASK, this.toNames(this.readClassAnnotationsFor((ClassInfo)classInfo)).visible);
            } else {
                writer.println(classInfo, INTERFACE_MASK, this.toNames(this.readInterfaceAnnotationsFor((ClassInfo)classInfo)).visible);
            }
        }

        private void writeMethods(ApiPrintWriter writer, List<MethodInfo> methods) {
            Collections.sort(methods);
            for (MethodInfo method : methods) {
                AnnotationInfoList methodAnnotations = method.getAnnotationInfo().directOnly();
                if (!ScanApi.isVisible(method.getModifiers()) || ScanApi.this.isExcluded(method) || !ScanApi.isValid(method.getModifiers(), METHOD_MASK) || this.hasInternalAnnotation(methodAnnotations.getNames()) || ScanApi.isEnumConstructor(method) || ScanApi.isKotlinInternalScope(method)) continue;
                writer.println(method, methodAnnotations.filter(this::isVisibleAnnotation), "  ");
            }
        }

        private void writeFields(ApiPrintWriter writer, List<FieldInfo> fields) {
            Collections.sort(fields);
            for (FieldInfo field : fields) {
                AnnotationInfoList fieldAnnotations = field.getAnnotationInfo().directOnly();
                if (!ScanApi.isVisible(field.getModifiers()) || !ScanApi.isValid(field.getModifiers(), FIELD_MASK) || this.hasInternalAnnotation(fieldAnnotations.getNames())) continue;
                writer.println(field, fieldAnnotations.filter(this::isVisibleAnnotation), "  ");
            }
        }

        private int getKotlinClassType(Class<?> javaClass) {
            Annotation metadata;
            if (this.metadataClass != null && (metadata = javaClass.getAnnotation(this.metadataClass)) != null) {
                try {
                    return (Integer)this.classTypeMethod.invoke((Object)metadata, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    Throwable ex = e instanceof InvocationTargetException ? e.getCause() : e;
                    ScanApi.this.getLogger().error("Failed to read Kotlin annotation", ex);
                    throw new InvalidUserCodeException(ex.getMessage(), ex);
                }
            }
            return 0;
        }

        @Nonnull
        private Names toNames(@Nonnull Collection<ClassInfo> classes) {
            Map<Boolean, List> partitioned = classes.stream().map(ClassInfo::getName).filter(x$0 -> ScanApi.isApplicationClass(x$0)).collect(Collectors.partitioningBy(this::isVisibleAnnotation, Collectors.toCollection(ArrayList::new)));
            List visible = partitioned.get(true);
            int idx = visible.indexOf(ScanApi.DONOTIMPLEMENT_ANNOTATION_NAME);
            if (idx != -1) {
                Collections.swap(visible, 0, idx);
                Collections.sort(visible.subList(1, visible.size()));
            } else {
                Collections.sort(visible);
            }
            return new Names(visible, ScanApi.ordering(partitioned.get(false)));
        }

        @Nonnull
        private Set<ClassInfo> readClassAnnotationsFor(@Nonnull ClassInfo classInfo) {
            HashSet<ClassInfo> annotations = new HashSet<ClassInfo>((Collection<ClassInfo>)classInfo.getAnnotations().directOnly());
            annotations.addAll(this.selectInheritedAnnotations((Collection<ClassInfo>)classInfo.getSuperclasses()));
            annotations.addAll(this.selectInheritedAnnotations((Collection<ClassInfo>)classInfo.getInterfaces().getImplementedInterfaces()));
            return annotations;
        }

        @Nonnull
        private Set<ClassInfo> readInterfaceAnnotationsFor(@Nonnull ClassInfo classInfo) {
            HashSet<ClassInfo> annotations = new HashSet<ClassInfo>((Collection<ClassInfo>)classInfo.getAnnotations().directOnly());
            annotations.addAll(this.selectInheritedAnnotations((Collection<ClassInfo>)classInfo.getInterfaces()));
            return annotations;
        }

        private List<ClassInfo> selectInheritedAnnotations(@Nonnull Collection<ClassInfo> classes) {
            return classes.stream().flatMap(cls -> cls.getAnnotations().directOnly().stream()).filter(ann -> this.inheritedAnnotations.contains(ann.getName())).collect(Collectors.toList());
        }

        private boolean isVisibleAnnotation(@Nonnull AnnotationInfo annotation) {
            return this.isVisibleAnnotation(annotation.getName());
        }

        private boolean isVisibleAnnotation(String className) {
            return !this.invisibleAnnotations.contains(className);
        }

        private boolean hasInternalAnnotation(@Nonnull Collection<String> annotationNames) {
            return annotationNames.stream().anyMatch(this.internalAnnotations::contains);
        }
    }
}

