/*
 * Decompiled with CFR 0.152.
 */
package net.corda.plugins.apiscanner;

import java.util.List;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;

public class ScannerExtension {
    private boolean enabled = true;
    private final Property<Boolean> verbose;
    private final SetProperty<String> excludeClasses;
    private final MapProperty<String, List> excludeMethods;
    private final SetProperty<String> excludePackages;
    private final Property<String> targetClassifier;

    @Inject
    public ScannerExtension(@Nonnull ObjectFactory objects, String defaultClassifier) {
        this.verbose = objects.property(Boolean.class).convention((Object)false);
        this.excludeClasses = objects.setProperty(String.class);
        this.excludePackages = objects.setProperty(String.class);
        this.excludeMethods = objects.mapProperty(String.class, List.class);
        this.targetClassifier = objects.property(String.class).convention((Object)defaultClassifier);
    }

    public Property<Boolean> getVerbose() {
        return this.verbose;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public SetProperty<String> getExcludeClasses() {
        return this.excludeClasses;
    }

    public MapProperty<String, ? extends List> getExcludeMethods() {
        return this.excludeMethods;
    }

    public SetProperty<String> getExcludePackages() {
        return this.excludePackages;
    }

    public Property<String> getTargetClassifier() {
        return this.targetClassifier;
    }
}

