/*
 * Decompiled with CFR 0.152.
 */
package net.greghaines.jesque.meta;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum KeyType {
    HASH("hash"),
    LIST("list"),
    NONE("none"),
    SET("set"),
    STRING("string"),
    ZSET("zset");

    private final String val;
    private static final Map<String, KeyType> valTypeMap;

    private KeyType(String val) {
        this.val = val;
    }

    public String toString() {
        return this.val;
    }

    public static KeyType getKeyTypeByValue(String val) {
        return valTypeMap.get(val);
    }

    static {
        HashMap<String, KeyType> vtm = new HashMap<String, KeyType>();
        for (KeyType keyType : KeyType.values()) {
            vtm.put(keyType.toString(), keyType);
        }
        valTypeMap = Collections.unmodifiableMap(vtm);
    }
}

