/*
 * Decompiled with CFR 0.152.
 */
package net.greghaines.jesque.utils;

import java.text.ParseException;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import net.greghaines.jesque.Job;
import net.greghaines.jesque.utils.AmbiguousConstructorException;
import net.greghaines.jesque.utils.NoSuchConstructorException;
import net.greghaines.jesque.utils.ReflectionUtils;
import net.greghaines.jesque.worker.UnpermittedJobException;

public final class JesqueUtils {
    private static final String BT_PREFIX = "\tat ";
    private static final String BT_CAUSED_BY_PREFIX = "Caused by: ";
    private static final String BT_UNKNOWN_SOURCE = "Unknown Source";
    private static final String BT_NATIVE_METHOD = "Native Method";
    private static final Pattern BT_PATTERN = Pattern.compile("[\\(\\):]");
    private static final Pattern COLON_SPACE_PATTERN = Pattern.compile(":\\s");

    public static String join(String sep, String ... strs) {
        return JesqueUtils.join(sep, Arrays.asList(strs));
    }

    public static String join(String sep, Iterable<String> strs) {
        StringBuilder buf = new StringBuilder();
        String prefix = "";
        for (String str : strs) {
            buf.append(prefix).append(str);
            prefix = sep;
        }
        return buf.toString();
    }

    public static String createKey(String namespace, String ... parts) {
        return JesqueUtils.createKey(namespace, Arrays.asList(parts));
    }

    public static String createRecurringHashKey(String queue) {
        return JesqueUtils.createKey(queue, "frequency");
    }

    public static String createKey(String namespace, Iterable<String> parts) {
        LinkedList<String> list = new LinkedList<String>();
        if (!"".equals(namespace)) {
            list.add(namespace);
        }
        for (String part : parts) {
            list.add(part);
        }
        return JesqueUtils.join(":", list);
    }

    public static List<String> createBacktrace(Throwable t) {
        LinkedList<String> bTrace = new LinkedList<String>();
        for (StackTraceElement ste : t.getStackTrace()) {
            bTrace.add(BT_PREFIX + ste.toString());
        }
        if (t.getCause() != null) {
            JesqueUtils.addCauseToBacktrace(t.getCause(), bTrace);
        }
        return bTrace;
    }

    private static void addCauseToBacktrace(Throwable cause, List<String> bTrace) {
        if (cause.getMessage() == null) {
            bTrace.add(BT_CAUSED_BY_PREFIX + cause.getClass().getName());
        } else {
            bTrace.add(BT_CAUSED_BY_PREFIX + cause.getClass().getName() + ": " + cause.getMessage());
        }
        for (StackTraceElement ste : cause.getStackTrace()) {
            bTrace.add(BT_PREFIX + ste.toString());
        }
        if (cause.getCause() != null) {
            JesqueUtils.addCauseToBacktrace(cause.getCause(), bTrace);
        }
    }

    public static Throwable recreateThrowable(String type, String message, List<String> backtrace) throws ParseException, ClassNotFoundException, NoSuchConstructorException, AmbiguousConstructorException, ReflectiveOperationException {
        LinkedList<String> bTrace = new LinkedList<String>(backtrace);
        Throwable cause = null;
        StackTraceElement[] stes = null;
        while (!bTrace.isEmpty()) {
            stes = JesqueUtils.recreateStackTrace(bTrace);
            if (bTrace.isEmpty()) continue;
            String line = bTrace.removeLast().substring(BT_CAUSED_BY_PREFIX.length());
            String[] classNameAndMsg = COLON_SPACE_PATTERN.split(line, 2);
            String msg = classNameAndMsg.length == 2 ? classNameAndMsg[1] : null;
            cause = JesqueUtils.instantiateThrowable(classNameAndMsg[0], msg, cause, stes);
        }
        return JesqueUtils.instantiateThrowable(type, message, cause, stes);
    }

    protected static Throwable instantiateThrowable(String type, String message, Throwable cause, StackTraceElement[] stes) throws ClassNotFoundException, AmbiguousConstructorException, ReflectiveOperationException, NoSuchConstructorException {
        Throwable throwable = null;
        boolean causeInited = false;
        Class<?> throwableType = ReflectionUtils.forName(type);
        if (message == null) {
            try {
                try {
                    throwable = (Throwable)ReflectionUtils.createObject(throwableType, new Object[0]);
                }
                catch (NoSuchConstructorException nsce2) {
                    if (cause == null) {
                        throw nsce2;
                    }
                    causeInited = true;
                    throwable = (Throwable)ReflectionUtils.createObject(throwableType, cause);
                }
            }
            catch (NoSuchConstructorException nsce) {
                try {
                    throwable = (Throwable)ReflectionUtils.createObject(throwableType, new Object[]{null});
                }
                catch (NoSuchConstructorException nsce3) {
                    if (cause == null) {
                        throw nsce3;
                    }
                    causeInited = true;
                    throwable = (Throwable)ReflectionUtils.createObject(throwableType, null, cause);
                }
            }
        } else {
            try {
                throwable = (Throwable)ReflectionUtils.createObject(throwableType, message);
            }
            catch (NoSuchConstructorException nsce) {
                if (cause == null) {
                    throw nsce;
                }
                causeInited = true;
                throwable = (Throwable)ReflectionUtils.createObject(throwableType, message, cause);
            }
        }
        throwable.setStackTrace(stes);
        if (!causeInited && cause != null) {
            throwable.initCause(cause);
        }
        return throwable;
    }

    protected static StackTraceElement[] recreateStackTrace(List<String> bTrace) throws ParseException {
        LinkedList<StackTraceElement> stes = new LinkedList<StackTraceElement>();
        if (bTrace != null) {
            String prev;
            ListIterator<String> iter = bTrace.listIterator(bTrace.size());
            while (iter.hasPrevious() && (prev = iter.previous()).startsWith(BT_PREFIX)) {
                int lineNumber;
                String fileName;
                iter.remove();
                String[] stParts = BT_PATTERN.split(prev.substring(BT_PREFIX.length()));
                if (stParts.length < 2 || stParts.length > 3) {
                    throw new ParseException("Malformed stack trace element string: " + prev, 0);
                }
                int periodPos = stParts[0].lastIndexOf(46);
                String className = stParts[0].substring(0, periodPos);
                String methodName = stParts[0].substring(periodPos + 1);
                if (BT_UNKNOWN_SOURCE.equals(stParts[1])) {
                    fileName = null;
                    lineNumber = -1;
                } else if (BT_NATIVE_METHOD.equals(stParts[1])) {
                    fileName = null;
                    lineNumber = -2;
                } else {
                    fileName = stParts[1];
                    lineNumber = stParts.length == 3 ? Integer.parseInt(stParts[2]) : -1;
                }
                stes.add(0, new StackTraceElement(className, methodName, fileName, lineNumber));
            }
        }
        return stes.toArray(new StackTraceElement[stes.size()]);
    }

    @SafeVarargs
    public static <K, V> Map<K, V> map(Map.Entry<? extends K, ? extends V> ... entries) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(entries.length);
        for (Map.Entry<K, V> entry : entries) {
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public static <K, V> Map.Entry<K, V> entry(K key, V value) {
        return new AbstractMap.SimpleImmutableEntry<K, V>(key, value);
    }

    @SafeVarargs
    public static <K> Set<K> set(K ... keys) {
        return new LinkedHashSet<K>(Arrays.asList(keys));
    }

    public static boolean nullSafeEquals(Object obj1, Object obj2) {
        return obj1 == null && obj2 == null || obj1 != null && obj2 != null && obj1.equals(obj2);
    }

    public static Object materializeJob(Job job) throws ClassNotFoundException, Exception {
        Class<?> clazz = ReflectionUtils.forName(job.getClassName());
        if (!Runnable.class.isAssignableFrom(clazz) && !Callable.class.isAssignableFrom(clazz)) {
            throw new ClassCastException("jobs must be a Runnable or a Callable: " + clazz.getName() + " - " + job);
        }
        return ReflectionUtils.createObject(clazz, job.getArgs(), job.getVars());
    }

    public static Object materializeJob(Job job, Map<String, Class<?>> jobTypes) throws UnpermittedJobException, Exception {
        String className = job.getClassName();
        Class<?> clazz = jobTypes.get(className);
        if (clazz == null) {
            throw new UnpermittedJobException(className);
        }
        if (!Runnable.class.isAssignableFrom(clazz) && !Callable.class.isAssignableFrom(clazz)) {
            throw new ClassCastException("jobs must be a Runnable or a Callable: " + clazz.getName() + " - " + job);
        }
        return ReflectionUtils.createObject(clazz, job.getArgs(), job.getVars());
    }

    public static boolean equal(Throwable ex1, Throwable ex2) {
        if (ex1 == ex2) {
            return true;
        }
        if (ex1 == null) {
            if (ex2 != null) {
                return false;
            }
        } else if (ex2 == null) {
            if (ex1 != null) {
                return false;
            }
        } else {
            if (ex1.getClass() != ex2.getClass()) {
                return false;
            }
            if (ex1.getMessage() == null ? ex2.getMessage() != null : !ex1.getMessage().equals(ex2.getMessage())) {
                return false;
            }
            if (!JesqueUtils.equal(ex1.getCause(), ex2.getCause())) {
                return false;
            }
        }
        return true;
    }

    private JesqueUtils() {
    }
}

