/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.database;

import iot.jcypher.database.DBType;
import iot.jcypher.database.DBVersion;
import iot.jcypher.database.IDBAccess;
import iot.jcypher.database.remote.BoltDBAccess;
import java.lang.reflect.Method;
import java.util.Properties;
import org.neo4j.driver.v1.AuthToken;

public class DBAccessFactory {
    public static IDBAccess createDBAccess(DBType dbType, Properties properties) {
        return DBAccessFactory.createDBAccess(dbType, properties, null, null, null);
    }

    public static IDBAccess createDBAccess(DBType dbType, Properties properties, String userId, String password) {
        return DBAccessFactory.createDBAccess(dbType, properties, userId, password, null);
    }

    public static IDBAccess createDBAccess(DBType dbType, Properties properties, AuthToken authToken) {
        return DBAccessFactory.createDBAccess(dbType, properties, null, null, authToken);
    }

    private static IDBAccess createDBAccess(DBType dbType, Properties properties, String userId, String password, AuthToken authToken) {
        Class<?> dbAccessClass = null;
        IDBAccess dbAccess = null;
        try {
            switch (dbType) {
                case REMOTE: {
                    if (properties == null) {
                        throw new RuntimeException("missing properties in database configuration");
                    }
                    boolean bolt = BoltDBAccess.isBoltProtocol(properties.getProperty("server_root_uri"));
                    if (!DBVersion.Neo4j_Version.startsWith("2") && bolt) {
                        dbAccessClass = Class.forName("iot.jcypher.database.remote.BoltDBAccess");
                        break;
                    }
                    dbAccessClass = Class.forName("iot.jcypher.database.remote.RemoteDBAccess");
                    break;
                }
                case EMBEDDED: {
                    if (properties == null) {
                        throw new RuntimeException("missing properties in database configuration");
                    }
                    dbAccessClass = Class.forName("iot.jcypher.database.embedded.EmbeddedDBAccess");
                    break;
                }
                case IN_MEMORY: {
                    dbAccessClass = Class.forName("iot.jcypher.database.embedded.InMemoryDBAccess");
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unexpected DBType: " + (Object)((Object)dbType));
                }
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        if (dbAccessClass != null) {
            try {
                Method init = dbAccessClass.getMethod("initialize", Properties.class);
                dbAccess = (IDBAccess)dbAccessClass.newInstance();
                init.invoke((Object)dbAccess, properties);
                if (dbType == DBType.REMOTE) {
                    if (userId != null && password != null) {
                        Method setAuth = dbAccessClass.getDeclaredMethod("setAuth", String.class, String.class);
                        setAuth.invoke((Object)dbAccess, userId, password);
                    } else if (authToken != null) {
                        Method setAuth = dbAccessClass.getDeclaredMethod("setAuth", AuthToken.class);
                        setAuth.invoke((Object)dbAccess, authToken);
                    }
                }
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return dbAccess;
    }
}

