/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.database.embedded;

import iot.jcypher.database.IDBAccess;
import iot.jcypher.database.embedded.ETransactionImpl;
import iot.jcypher.database.internal.DBUtil;
import iot.jcypher.database.internal.IDBAccessInit;
import iot.jcypher.database.util.QParamsUtil;
import iot.jcypher.query.JcQuery;
import iot.jcypher.query.JcQueryResult;
import iot.jcypher.query.result.JcError;
import iot.jcypher.query.writer.CypherWriter;
import iot.jcypher.query.writer.QueryParam;
import iot.jcypher.query.writer.WriterContext;
import iot.jcypher.transaction.ITransaction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import org.neo4j.driver.v1.AuthToken;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import scala.collection.convert.Wrappers;

public abstract class AbstractEmbeddedDBAccess
implements IDBAccessInit {
    private ThreadLocal<ETransactionImpl> transaction = new ThreadLocal();
    protected Properties properties;
    private GraphDatabaseService graphDb;
    private Thread shutdownHook;
    private boolean registerShutdownHook = true;

    public AbstractEmbeddedDBAccess() {
    }

    public AbstractEmbeddedDBAccess(GraphDatabaseService gdbs) {
        this.graphDb = gdbs;
    }

    @Override
    public JcQueryResult execute(JcQuery query) {
        ArrayList<JcQuery> qList = new ArrayList<JcQuery>();
        qList.add(query);
        List<JcQueryResult> qrList = this.execute(qList);
        return qrList.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<JcQueryResult> execute(List<JcQuery> queries) {
        ArrayList<Statement> statements = new ArrayList<Statement>(queries.size());
        for (JcQuery query : queries) {
            WriterContext context = new WriterContext();
            QueryParam.setExtractParams(query.isExtractParams(), context);
            CypherWriter.toCypherExpression(query, context);
            String cypher = context.buffer.toString();
            Map<String, Object> paramsMap = QParamsUtil.createQueryParams(context);
            statements.add(new Statement(cypher, paramsMap));
        }
        JsonBuilderContext builderContext = new JsonBuilderContext();
        this.initJsonBuilderContext(builderContext);
        Throwable exception = null;
        GraphDatabaseService engine = null;
        try {
            engine = this.getGraphDB();
        }
        catch (Throwable e) {
            exception = e;
        }
        Result result = null;
        Transaction tx = null;
        Throwable dbException = null;
        if (engine != null) {
            ETransactionImpl etx = null;
            etx = this.transaction.get();
            tx = etx != null ? etx.getTransaction() : this.getGraphDB().beginTx();
            try {
                for (Statement statement : statements) {
                    result = statement.parameterMap != null ? engine.execute(statement.cypher, statement.parameterMap) : engine.execute(statement.cypher);
                    this.addInnerResultsAndDataArray(builderContext);
                    List cols = result.columns();
                    this.addColumns(builderContext, cols);
                    while (result.hasNext()) {
                        Map row = result.next();
                        this.addRow(builderContext, row, cols);
                    }
                }
                if (etx == null) {
                    tx.success();
                }
            }
            catch (Throwable e) {
                dbException = e;
                if (tx != null) {
                    tx.failure();
                }
            }
            finally {
                if (etx == null && tx != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable e1) {
                        dbException = e1;
                    }
                }
            }
        }
        if (dbException != null) {
            this.addDBError(builderContext, dbException);
        }
        JsonObject jsonResult = builderContext.build();
        ArrayList<JcQueryResult> ret = new ArrayList<JcQueryResult>(queries.size());
        for (int i = 0; i < queries.size(); ++i) {
            JcQueryResult qr = new JcQueryResult(jsonResult, i, this);
            ret.add(qr);
            if (exception == null) continue;
            String typ = exception.getClass().getSimpleName();
            String msg = exception.getLocalizedMessage();
            qr.addGeneralError(new JcError(typ, msg, DBUtil.getStacktrace(exception)));
        }
        return ret;
    }

    @Override
    public List<JcError> clearDatabase() {
        return DBUtil.clearDatabase(this);
    }

    @Override
    public ITransaction beginTX() {
        ETransactionImpl tx = this.transaction.get();
        if (tx == null) {
            tx = new ETransactionImpl(this);
            this.transaction.set(tx);
        }
        return tx;
    }

    @Override
    public ITransaction getTX() {
        return this.transaction.get();
    }

    @Override
    public boolean isDatabaseEmpty() {
        return DBUtil.isDatabaseEmpty(this);
    }

    @Override
    public synchronized void close() {
        if (this.shutdownHook != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            this.shutdownHook = null;
        }
        this.shutDown();
        this.graphDb = null;
    }

    @Override
    public void setAuth(String userId, String password) {
    }

    @Override
    public void setAuth(AuthToken authToken) {
    }

    @Override
    public IDBAccess removeShutdownHook() {
        this.registerShutdownHook = false;
        if (this.shutdownHook != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            this.shutdownHook = null;
        }
        return this;
    }

    @Override
    public IDBAccess addShutdownHook() {
        this.registerShutdownHook = true;
        if (this.shutdownHook == null) {
            Thread hook = new Thread(){

                @Override
                public void run() {
                    AbstractEmbeddedDBAccess.this.shutDown();
                }
            };
            Runtime.getRuntime().addShutdownHook(hook);
            this.shutdownHook = hook;
        }
        return this;
    }

    protected void shutDown() {
        try {
            if (this.graphDb != null) {
                this.graphDb.shutdown();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void addDBError(JsonBuilderContext builderContext, Throwable exception) {
        String code = exception.getClass().getSimpleName();
        String msg = exception.getLocalizedMessage();
        JsonObjectBuilder errorObject = Json.createObjectBuilder();
        errorObject.add("code", code);
        if (msg == null) {
            msg = code;
        }
        errorObject.add("message", msg);
        errorObject.add("info", DBUtil.getStacktrace(exception));
        builderContext.errorsArray.add(errorObject);
    }

    protected abstract GraphDatabaseService createGraphDB();

    public synchronized GraphDatabaseService getGraphDB() {
        if (this.graphDb == null) {
            this.graphDb = this.createGraphDB();
            this.shutdownHook = this.registerShutdownHook();
        }
        return this.graphDb;
    }

    private void initJsonBuilderContext(JsonBuilderContext builderContext) {
        builderContext.resultObject = Json.createObjectBuilder();
        builderContext.resultsArray = Json.createArrayBuilder();
        builderContext.errorsArray = Json.createArrayBuilder();
        builderContext.innerResultsObjects = new ArrayList();
        builderContext.dataArrays = new ArrayList();
    }

    private void addInnerResultsAndDataArray(JsonBuilderContext builderContext) {
        builderContext.innerResultsObjects.add(Json.createObjectBuilder());
        builderContext.dataArrays.add(Json.createArrayBuilder());
    }

    private void addColumns(JsonBuilderContext builderContext, List<String> cols) {
        JsonArrayBuilder columns = Json.createArrayBuilder();
        for (String col : cols) {
            columns.add(col);
        }
        ((JsonObjectBuilder)builderContext.innerResultsObjects.get(builderContext.innerResultsObjects.size() - 1)).add("columns", columns);
    }

    private void addRow(JsonBuilderContext builderContext, Map<String, Object> row, List<String> cols) {
        JsonObjectBuilder rowObject = Json.createObjectBuilder();
        JsonArrayBuilder restArray = Json.createArrayBuilder();
        JsonObjectBuilder graphObject = Json.createObjectBuilder();
        JsonArrayBuilder nodesArray = Json.createArrayBuilder();
        JsonArrayBuilder relationsArray = Json.createArrayBuilder();
        ArrayList<NodeHolder> nodes = new ArrayList<NodeHolder>();
        ArrayList<RelationHolder> relations = new ArrayList<RelationHolder>();
        for (int i = 0; i < cols.size(); ++i) {
            Object restObject = null;
            String key = cols.get(i);
            Object val = row.get(key);
            restObject = this.buildRestObject(val, nodes, relations);
            if (restObject == null) {
                AbstractEmbeddedDBAccess.writeLiteralValue(val, restArray);
                continue;
            }
            if (restObject instanceof JsonObjectBuilder) {
                restArray.add((JsonObjectBuilder)restObject);
                continue;
            }
            if (!(restObject instanceof JsonArrayBuilder)) continue;
            restArray.add((JsonArrayBuilder)restObject);
        }
        Collections.sort(nodes);
        Collections.sort(relations);
        for (NodeHolder nh : nodes) {
            nodesArray.add(nh.nodeObject);
        }
        for (RelationHolder rh : relations) {
            relationsArray.add(rh.relationObject);
        }
        rowObject.add("rest", restArray);
        graphObject.add("nodes", nodesArray);
        graphObject.add("relationships", relationsArray);
        rowObject.add("graph", graphObject);
        ((JsonArrayBuilder)builderContext.dataArrays.get(builderContext.dataArrays.size() - 1)).add(rowObject);
    }

    private Object buildRestObject(Object val, List<NodeHolder> nodes, List<RelationHolder> relations) {
        JsonObjectBuilder restObject = null;
        JsonArrayBuilder jsarr = null;
        if (val instanceof Node) {
            restObject = Json.createObjectBuilder();
            Node node = (Node)val;
            restObject.add("self", "node/".concat(String.valueOf(node.getId())));
            this.addNode(node, nodes);
        } else if (val instanceof Relationship) {
            restObject = Json.createObjectBuilder();
            Relationship relation = (Relationship)val;
            restObject.add("start", "node/".concat(String.valueOf(relation.getStartNode().getId())));
            restObject.add("self", "relationship/".concat(String.valueOf(relation.getId())));
            restObject.add("end", "node/".concat(String.valueOf(relation.getEndNode().getId())));
            RelationHolder rh = new RelationHolder(relation);
            if (!relations.contains(rh)) {
                RelationHolder.RelationNodes nds = rh.init(relation);
                this.addNode(nds.startNode, nodes);
                this.addNode(nds.endNode, nodes);
                relations.add(rh);
            }
        } else if (val instanceof Path) {
            restObject = Json.createObjectBuilder();
            Path path = (Path)val;
            restObject.add("start", "node/".concat(String.valueOf(path.startNode().getId())));
            JsonArrayBuilder pNodesArray = Json.createArrayBuilder();
            for (Node node : path.nodes()) {
                pNodesArray.add("node/".concat(String.valueOf(node.getId())));
                this.addNode(node, nodes);
            }
            restObject.add("nodes", pNodesArray);
            restObject.add("length", path.length());
            JsonArrayBuilder pRelationsArray = Json.createArrayBuilder();
            for (Relationship relation : path.relationships()) {
                pRelationsArray.add("relationship/".concat(String.valueOf(relation.getId())));
                RelationHolder rh = new RelationHolder(relation);
                if (relations.contains(rh)) continue;
                rh.init(relation);
                relations.add(rh);
            }
            restObject.add("relationships", pRelationsArray);
            restObject.add("end", "node/".concat(String.valueOf(path.endNode().getId())));
        } else if (val instanceof Wrappers.SeqWrapper) {
            jsarr = Json.createArrayBuilder();
            int sz = ((Wrappers.SeqWrapper)val).size();
            boolean restFound = false;
            for (int i = 0; i < sz; ++i) {
                Object obj = ((Wrappers.SeqWrapper)val).get(i);
                Object ro = this.buildRestObject(obj, nodes, relations);
                if (ro instanceof JsonObjectBuilder) {
                    jsarr.add((JsonObjectBuilder)ro);
                    restFound = true;
                    continue;
                }
                if (!(ro instanceof JsonArrayBuilder)) continue;
                jsarr.add((JsonArrayBuilder)ro);
                restFound = true;
            }
            if (!restFound) {
                jsarr = null;
            }
        }
        if (restObject != null) {
            return restObject;
        }
        if (jsarr != null) {
            return jsarr;
        }
        return null;
    }

    private static void writeLiteralValue(Object val, JsonArrayBuilder array) {
        if (val == null) {
            array.addNull();
        } else if (val instanceof String) {
            array.add(val.toString());
        } else if (val instanceof Number) {
            if (val instanceof Long) {
                array.add(((Long)val).longValue());
            } else if (val instanceof Integer) {
                array.add(((Integer)val).intValue());
            } else if (val instanceof Double) {
                array.add(((Double)val).doubleValue());
            } else if (val instanceof Float) {
                array.add((double)((Float)val).floatValue());
            }
        } else if (val instanceof Boolean) {
            array.add(((Boolean)val).booleanValue());
        } else if (val != null && val.getClass().isArray()) {
            JsonArrayBuilder jsarr = Json.createArrayBuilder();
            if (val instanceof int[]) {
                int[] arr;
                for (int v : arr = (int[])val) {
                    AbstractEmbeddedDBAccess.writeLiteralValue(v, jsarr);
                }
            } else if (val instanceof long[]) {
                long[] arr;
                for (long v : arr = (long[])val) {
                    AbstractEmbeddedDBAccess.writeLiteralValue(v, jsarr);
                }
            } else if (val instanceof float[]) {
                float[] arr;
                for (float v : arr = (float[])val) {
                    AbstractEmbeddedDBAccess.writeLiteralValue(Float.valueOf(v), jsarr);
                }
            } else if (val instanceof double[]) {
                double[] arr;
                for (double v : arr = (double[])val) {
                    AbstractEmbeddedDBAccess.writeLiteralValue(v, jsarr);
                }
            } else {
                Object[] arr;
                for (Object v : arr = (Object[])val) {
                    AbstractEmbeddedDBAccess.writeLiteralValue(v, jsarr);
                }
            }
            array.add(jsarr);
        } else if (val instanceof Wrappers.SeqWrapper) {
            JsonArrayBuilder jsarr = Json.createArrayBuilder();
            int sz = ((Wrappers.SeqWrapper)val).size();
            for (int i = 0; i < sz; ++i) {
                Object obj = ((Wrappers.SeqWrapper)val).get(i);
                AbstractEmbeddedDBAccess.writeLiteralValue(obj, jsarr);
            }
            array.add(jsarr);
        }
    }

    private void addNode(Node node, List<NodeHolder> nodes) {
        NodeHolder nh;
        if (node != null && !nodes.contains(nh = new NodeHolder(node))) {
            nh.init(node);
            nodes.add(nh);
        }
    }

    void removeTx() {
        this.transaction.remove();
    }

    private Thread registerShutdownHook() {
        Thread hook = null;
        if (this.registerShutdownHook) {
            hook = new Thread(){

                @Override
                public void run() {
                    AbstractEmbeddedDBAccess.this.shutDown();
                }
            };
            Runtime.getRuntime().addShutdownHook(hook);
        }
        return hook;
    }

    private static class Statement {
        private String cypher;
        private Map<String, Object> parameterMap;

        private Statement(String cypher, Map<String, Object> parameterMap) {
            this.cypher = cypher;
            this.parameterMap = parameterMap;
        }
    }

    private static class RelationHolder
    implements Comparable<RelationHolder> {
        private long id;
        private JsonObjectBuilder relationObject;

        private RelationHolder(Relationship relation) {
            this.id = relation.getId();
        }

        private RelationNodes init(Relationship relation) {
            Node en;
            Node sn;
            RelationNodes ret = new RelationNodes();
            JsonObjectBuilder rel = Json.createObjectBuilder();
            rel.add("id", String.valueOf(relation.getId()));
            RelationshipType typ = relation.getType();
            if (typ != null) {
                rel.add("type", typ.name());
            }
            if ((sn = relation.getStartNode()) != null) {
                rel.add("startNode", String.valueOf(sn.getId()));
                ret.startNode = sn;
            }
            if ((en = relation.getEndNode()) != null) {
                rel.add("endNode", String.valueOf(en.getId()));
                ret.endNode = en;
            }
            JsonObjectBuilder props = Json.createObjectBuilder();
            for (String pKey : relation.getPropertyKeys()) {
                Object pval = relation.getProperty(pKey);
                this.writeLiteral(pKey, pval, props);
            }
            rel.add("properties", props);
            this.relationObject = rel;
            return ret;
        }

        private void writeLiteral(String key, Object val, JsonObjectBuilder props) {
            if (val instanceof String) {
                props.add(key, val.toString());
            } else if (val instanceof Number) {
                if (val instanceof Long) {
                    props.add(key, ((Long)val).longValue());
                } else if (val instanceof Integer) {
                    props.add(key, ((Integer)val).intValue());
                } else if (val instanceof Double) {
                    props.add(key, ((Double)val).doubleValue());
                } else if (val instanceof Float) {
                    props.add(key, (double)((Float)val).floatValue());
                }
            } else if (val instanceof Boolean) {
                props.add(key, ((Boolean)val).booleanValue());
            }
        }

        public int hashCode() {
            return (int)this.id;
        }

        public boolean equals(Object obj) {
            if (obj instanceof RelationHolder) {
                return ((RelationHolder)obj).id == this.id;
            }
            return false;
        }

        @Override
        public int compareTo(RelationHolder o) {
            return Long.compare(this.id, o.id);
        }

        private static class RelationNodes {
            private Node startNode;
            private Node endNode;

            private RelationNodes() {
            }
        }
    }

    private static class NodeHolder
    implements Comparable<NodeHolder> {
        private long id;
        private JsonObjectBuilder nodeObject;

        private NodeHolder(Node node) {
            this.id = node.getId();
        }

        private void init(Node node) {
            JsonObjectBuilder nd = Json.createObjectBuilder();
            nd.add("id", String.valueOf(node.getId()));
            JsonArrayBuilder labels = Json.createArrayBuilder();
            Iterator lblIter = node.getLabels().iterator();
            boolean hasLabels = false;
            while (lblIter.hasNext()) {
                hasLabels = true;
                Label lab = (Label)lblIter.next();
                labels.add(lab.name());
            }
            if (hasLabels) {
                nd.add("labels", labels);
            }
            JsonObjectBuilder props = Json.createObjectBuilder();
            for (String pKey : node.getPropertyKeys()) {
                Object pval = node.getProperty(pKey);
                NodeHolder.writeLiteral(pKey, pval, props);
            }
            nd.add("properties", props);
            this.nodeObject = nd;
        }

        private static void writeLiteral(String key, Object val, JsonObjectBuilder props) {
            if (val instanceof String) {
                props.add(key, val.toString());
            } else if (val instanceof Number) {
                if (val instanceof Long) {
                    props.add(key, ((Long)val).longValue());
                } else if (val instanceof Integer) {
                    props.add(key, ((Integer)val).intValue());
                } else if (val instanceof Double) {
                    props.add(key, ((Double)val).doubleValue());
                } else if (val instanceof Float) {
                    props.add(key, (double)((Float)val).floatValue());
                }
            } else if (val instanceof Boolean) {
                props.add(key, ((Boolean)val).booleanValue());
            } else if (val != null && val.getClass().isArray()) {
                JsonArrayBuilder jsarr = Json.createArrayBuilder();
                if (val instanceof int[]) {
                    int[] arr;
                    for (int v : arr = (int[])val) {
                        AbstractEmbeddedDBAccess.writeLiteralValue(v, jsarr);
                    }
                } else if (val instanceof long[]) {
                    long[] arr;
                    for (long v : arr = (long[])val) {
                        AbstractEmbeddedDBAccess.writeLiteralValue(v, jsarr);
                    }
                } else if (val instanceof float[]) {
                    float[] arr;
                    for (float v : arr = (float[])val) {
                        AbstractEmbeddedDBAccess.writeLiteralValue(Float.valueOf(v), jsarr);
                    }
                } else if (val instanceof double[]) {
                    double[] arr;
                    for (double v : arr = (double[])val) {
                        AbstractEmbeddedDBAccess.writeLiteralValue(v, jsarr);
                    }
                } else {
                    Object[] arr;
                    for (Object v : arr = (Object[])val) {
                        AbstractEmbeddedDBAccess.writeLiteralValue(v, jsarr);
                    }
                }
                props.add(key, jsarr);
            }
        }

        public int hashCode() {
            return (int)this.id;
        }

        public boolean equals(Object obj) {
            if (obj instanceof NodeHolder) {
                return ((NodeHolder)obj).id == this.id;
            }
            return false;
        }

        @Override
        public int compareTo(NodeHolder o) {
            return Long.compare(this.id, o.id);
        }
    }

    private static class JsonBuilderContext {
        private JsonObjectBuilder resultObject;
        private JsonArrayBuilder resultsArray;
        private JsonArrayBuilder errorsArray;
        private List<JsonObjectBuilder> innerResultsObjects;
        private List<JsonArrayBuilder> dataArrays;

        private JsonBuilderContext() {
        }

        private JsonObject build() {
            for (int i = 0; i < this.innerResultsObjects.size(); ++i) {
                this.innerResultsObjects.get(i).add("data", this.dataArrays.get(i));
                this.resultsArray.add(this.innerResultsObjects.get(i));
            }
            this.resultObject.add("results", this.resultsArray);
            this.resultObject.add("errors", this.errorsArray);
            return this.resultObject.build();
        }
    }
}

