/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.database.embedded;

import iot.jcypher.database.DBType;
import iot.jcypher.database.embedded.AbstractEmbeddedDBAccess;
import java.util.Properties;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.test.TestGraphDatabaseFactory;

public class InMemoryDBAccess
extends AbstractEmbeddedDBAccess {
    public InMemoryDBAccess() {
    }

    public InMemoryDBAccess(GraphDatabaseService gdbs) {
        super(gdbs);
    }

    @Override
    public void initialize(Properties properties) {
        this.properties = properties;
    }

    @Override
    public DBType getDBType() {
        return DBType.IN_MEMORY;
    }

    @Override
    protected GraphDatabaseService createGraphDB() {
        GraphDatabaseBuilder builder = new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder();
        if (this.properties != null) {
            if (this.properties.getProperty("pagecache_memory") != null) {
                builder.setConfig(GraphDatabaseSettings.pagecache_memory, "pagecache_memory");
            }
            if (this.properties.getProperty("string_block_size") != null) {
                builder.setConfig(GraphDatabaseSettings.string_block_size, "array_block_size");
            }
            if (this.properties.getProperty("string_block_size") != null) {
                builder.setConfig(GraphDatabaseSettings.array_block_size, "array_block_size");
            }
        }
        return builder.newGraphDatabase();
    }
}

