/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.database.remote;

import iot.jcypher.database.DBType;
import iot.jcypher.database.IDBAccess;
import iot.jcypher.database.internal.DBUtil;
import iot.jcypher.database.internal.IDBAccessInit;
import iot.jcypher.query.JcQuery;
import iot.jcypher.query.JcQueryResult;
import iot.jcypher.query.result.JcError;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public abstract class AbstractRemoteDBAccess
implements IDBAccessInit {
    protected Thread shutdownHook;
    protected Properties properties;
    private boolean registerShutdownHook = true;

    @Override
    public JcQueryResult execute(JcQuery query) {
        ArrayList<JcQuery> qList = new ArrayList<JcQuery>();
        qList.add(query);
        List<JcQueryResult> qrList = this.execute(qList);
        return qrList.get(0);
    }

    @Override
    public List<JcError> clearDatabase() {
        return DBUtil.clearDatabase(this);
    }

    @Override
    public boolean isDatabaseEmpty() {
        return DBUtil.isDatabaseEmpty(this);
    }

    @Override
    public DBType getDBType() {
        return DBType.REMOTE;
    }

    @Override
    public void close() {
        if (this.shutdownHook != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            this.shutdownHook = null;
        }
        this.shutDown();
    }

    @Override
    public void initialize(Properties properties) {
        this.properties = properties;
        if (this.properties.getProperty("server_root_uri") == null) {
            throw new RuntimeException("missing property: 'server_root_uri' in database configuration");
        }
    }

    @Override
    public IDBAccess removeShutdownHook() {
        this.registerShutdownHook = false;
        if (this.shutdownHook != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            this.shutdownHook = null;
        }
        return this;
    }

    @Override
    public IDBAccess addShutdownHook() {
        this.registerShutdownHook = true;
        if (this.shutdownHook == null) {
            Thread hook = new Thread(){

                @Override
                public void run() {
                    AbstractRemoteDBAccess.this.shutDown();
                }
            };
            Runtime.getRuntime().addShutdownHook(hook);
            this.shutdownHook = hook;
        }
        return this;
    }

    protected abstract void shutDown();

    protected Thread registerShutdownHook() {
        Thread hook = null;
        if (this.registerShutdownHook) {
            hook = new Thread(){

                @Override
                public void run() {
                    AbstractRemoteDBAccess.this.shutDown();
                }
            };
            Runtime.getRuntime().addShutdownHook(hook);
        }
        return hook;
    }
}

