/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.database.remote;

import iot.jcypher.database.internal.DBUtil;
import iot.jcypher.database.remote.BoltDBAccess;
import iot.jcypher.query.result.JcError;
import iot.jcypher.transaction.internal.AbstractTransaction;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.driver.v1.Transaction;

public class BoltTransactionImpl
extends AbstractTransaction {
    private Transaction transaction;

    public BoltTransactionImpl(BoltDBAccess dbAccess) {
        super(dbAccess);
    }

    @Override
    public List<JcError> close() {
        List<JcError> errors;
        if (this.isClosed()) {
            throw new RuntimeException("transaction has already been closed");
        }
        if (!this.isMyThread()) {
            throw new RuntimeException("close() must be called from within the same thread which created this transaction");
        }
        BoltDBAccess bdba = this.getBoltDBAccess();
        bdba.removeTx();
        if (this.transaction != null) {
            Transaction tx = this.getTransaction();
            if (this.failed) {
                tx.failure();
            } else {
                tx.success();
            }
            Throwable dbException = null;
            try {
                tx.close();
            }
            catch (Throwable e) {
                dbException = e;
            }
            errors = DBUtil.buildErrorList(null, dbException);
        } else {
            errors = new ArrayList<JcError>();
        }
        if (errors.size() > 0) {
            this.failure();
        }
        this.setClosed();
        return errors;
    }

    public Transaction getTransaction() {
        if (this.transaction == null) {
            BoltDBAccess bdba = this.getBoltDBAccess();
            this.transaction = bdba.getSession().beginTransaction();
        }
        return this.transaction;
    }

    private BoltDBAccess getBoltDBAccess() {
        return (BoltDBAccess)this.getDBAccess();
    }
}

