/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.database.remote;

import iot.jcypher.database.internal.DBUtil;
import iot.jcypher.database.remote.RemoteDBAccess;
import iot.jcypher.query.result.JcError;
import iot.jcypher.transaction.internal.AbstractTransaction;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class RTransactionImpl
extends AbstractTransaction {
    private static final String transactionalURLPostfix = "db/data/transaction";
    private static final String txCommit = "/commit";
    private static final String emptyJSON = "{\"statements\" : [ ]}";
    private Invocation.Builder invocationBuilder_open;
    private Invocation.Builder invocationBuilder_next;
    private String txLocation;

    public RTransactionImpl(RemoteDBAccess dbAccess) {
        super(dbAccess);
    }

    @Override
    public List<JcError> close() {
        List<JcError> errors;
        if (this.isClosed()) {
            throw new RuntimeException("transaction has already been closed");
        }
        if (!this.isMyThread()) {
            throw new RuntimeException("close() must be called from within the same thread which created this transaction");
        }
        RemoteDBAccess rdba = this.getRDBAccess();
        rdba.removeTx();
        if (this.invocationBuilder_open != null) {
            Invocation.Builder iBuilder;
            if (this.failed) {
                iBuilder = this.createNextInvocationBuilder();
            } else {
                WebTarget serverRootTarget = rdba.getRestClient().target(rdba.getServerRootUri());
                WebTarget transactionalTarget = serverRootTarget.path(this.txLocation.concat(txCommit));
                iBuilder = transactionalTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
                if (rdba.getAuth() != null) {
                    iBuilder = iBuilder.header("Authorization", (Object)rdba.getAuth());
                }
            }
            Response response = null;
            Throwable exception = null;
            try {
                response = this.failed ? iBuilder.delete() : iBuilder.post(Entity.entity((Object)emptyJSON, (MediaType)MediaType.APPLICATION_JSON_TYPE));
            }
            catch (Throwable e) {
                exception = e;
            }
            errors = DBUtil.buildErrorList(response, exception);
        } else {
            errors = new ArrayList<JcError>();
        }
        if (errors.size() > 0) {
            this.failure();
        }
        this.setClosed();
        return errors;
    }

    private RemoteDBAccess getRDBAccess() {
        return (RemoteDBAccess)this.getDBAccess();
    }

    public synchronized Invocation.Builder getInvocationBuilder() {
        Invocation.Builder ret;
        RemoteDBAccess rdba = this.getRDBAccess();
        if (this.invocationBuilder_open == null) {
            WebTarget serverRootTarget = rdba.getRestClient().target(rdba.getServerRootUri());
            WebTarget transactionalTarget = serverRootTarget.path(transactionalURLPostfix);
            this.invocationBuilder_open = transactionalTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
            if (rdba.getAuth() != null) {
                this.invocationBuilder_open = this.invocationBuilder_open.header("Authorization", (Object)rdba.getAuth());
            }
            ret = this.invocationBuilder_open;
        } else {
            ret = this.invocationBuilder_next == null ? (this.invocationBuilder_next = this.createNextInvocationBuilder()) : this.invocationBuilder_next;
        }
        return ret;
    }

    public void setTxLocation(String txLoc) {
        if (this.txLocation == null) {
            int idx = txLoc.indexOf(transactionalURLPostfix);
            this.txLocation = txLoc.substring(idx);
        }
    }

    private Invocation.Builder createNextInvocationBuilder() {
        RemoteDBAccess rdba = this.getRDBAccess();
        WebTarget serverRootTarget = rdba.getRestClient().target(rdba.getServerRootUri());
        WebTarget transactionalTarget = serverRootTarget.path(this.txLocation);
        Invocation.Builder ret = transactionalTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        if (rdba.getAuth() != null) {
            ret = ret.header("Authorization", (Object)rdba.getAuth());
        }
        return ret;
    }
}

