/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.database.util;

import iot.jcypher.query.writer.IQueryParam;
import iot.jcypher.query.writer.QueryParam;
import iot.jcypher.query.writer.QueryParamSet;
import iot.jcypher.query.writer.WriterContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QParamsUtil {
    public static Map<String, Object> createQueryParams(WriterContext context) {
        List<IQueryParam> params;
        HashMap<String, Object> paramsMap = null;
        if (QueryParam.isExtractParams(context) && (params = QueryParamSet.getQueryParams(context)) != null) {
            for (IQueryParam iparam : params) {
                if (paramsMap == null) {
                    paramsMap = new HashMap<String, Object>();
                }
                if (iparam instanceof QueryParamSet) {
                    QueryParamSet paramSet = (QueryParamSet)iparam;
                    if (paramSet.canUseSet() && paramSet.getQueryParams().size() > 1) {
                        QParamsUtil.writeAsSet(paramSet, paramsMap);
                        continue;
                    }
                    QParamsUtil.writeAsParams(paramSet, paramsMap);
                    continue;
                }
                if (!(iparam instanceof QueryParam)) continue;
                String key = ((QueryParam)iparam).getKey();
                Object val = ((QueryParam)iparam).getValue();
                val = QParamsUtil.convertVal(val);
                paramsMap.put(key, val);
            }
        }
        return paramsMap;
    }

    private static void writeAsSet(QueryParamSet paramSet, Map<String, Object> paramsMap) {
        HashMap<String, Object> set = new HashMap<String, Object>();
        paramsMap.put(paramSet.getKey(), set);
        for (QueryParam param : paramSet.getQueryParams()) {
            String key = param.getOrgName();
            Object val = param.getValue();
            val = QParamsUtil.convertVal(val);
            set.put(key, val);
        }
    }

    private static void writeAsParams(QueryParamSet paramSet, Map<String, Object> paramsMap) {
        for (QueryParam param : paramSet.getQueryParams()) {
            String key = param.getKey();
            Object val = param.getValue();
            val = QParamsUtil.convertVal(val);
            paramsMap.put(key, val);
        }
    }

    private static Object convertVal(Object val) {
        if (!(val instanceof Number || val instanceof Boolean || val instanceof List)) {
            return val.toString();
        }
        return val;
    }
}

