/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.domain.genericmodel;

import iot.jcypher.domain.genericmodel.DOField;
import iot.jcypher.domain.genericmodel.internal.DomainModel;
import iot.jcypher.domain.mapping.MappingUtil;
import java.util.ArrayList;
import java.util.List;

public class DOType {
    private long nodeId;
    private String name;
    private Kind kind;
    private DOType superType;
    private List<DOType> interfaces;
    private List<DOField> declaredFields;
    private List<String> declaredFieldNames;
    private boolean buildIn;
    private DomainModel domainModel;

    DOClassBuilder createClassBuilder() {
        DOClassBuilder ret = new DOClassBuilder();
        ret.setKind(Kind.CLASS);
        return ret;
    }

    DOInterfaceBuilder createInterfaceBuilder() {
        DOInterfaceBuilder ret = new DOInterfaceBuilder();
        ret.setKind(Kind.INTERFACE);
        return ret;
    }

    DOEnumBuilder createEnumBuilder() {
        DOEnumBuilder ret = new DOEnumBuilder();
        ret.setKind(Kind.ENUM);
        return ret;
    }

    DOType(String typeName, DomainModel domainModel) {
        this.name = typeName;
        this.declaredFields = new ArrayList<DOField>();
        this.interfaces = new ArrayList<DOType>();
        this.nodeId = -1L;
        this.buildIn = DomainModel.isBuildIn(typeName);
        this.domainModel = domainModel;
    }

    public String getName() {
        return this.name;
    }

    public List<DOField> getDeclaredFields() {
        return this.declaredFields;
    }

    public List<DOField> getFields() {
        ArrayList<DOField> ret = new ArrayList<DOField>();
        for (DOType typ = this; typ != null; typ = typ.getSuperType()) {
            ret.addAll(typ.getDeclaredFields());
        }
        return ret;
    }

    public List<String> getDeclaredFieldNames() {
        if (this.declaredFieldNames == null) {
            this.declaredFieldNames = new ArrayList<String>(this.declaredFields.size());
            for (DOField f : this.declaredFields) {
                this.declaredFieldNames.add(f.getName());
            }
        }
        return this.declaredFieldNames;
    }

    public List<String> getFieldNames() {
        ArrayList<String> ret = new ArrayList<String>();
        for (DOType typ = this; typ != null; typ = typ.getSuperType()) {
            ret.addAll(typ.getDeclaredFieldNames());
        }
        return ret;
    }

    public DOField getFieldByIndex(int index) {
        return this.getFields().get(index);
    }

    public int getIndexOfField(String fieldName) {
        List<String> fnms = this.getFieldNames();
        for (int i = 0; i < fnms.size(); ++i) {
            if (!fnms.get(i).equals(fieldName)) continue;
            return i;
        }
        return -1;
    }

    public DOField getFieldByName(String fieldName) {
        int idx = this.getIndexOfField(fieldName);
        if (idx != -1) {
            return this.getFieldByIndex(idx);
        }
        return null;
    }

    public DOType getSuperType() {
        return this.superType;
    }

    public List<DOType> getInterfaces() {
        return this.interfaces;
    }

    public Kind getKind() {
        return this.kind;
    }

    public Object getEnumValue(String name) {
        if (this.kind != Kind.ENUM) {
            throw new RuntimeException("getEnumValue(..) can only be called on an enum");
        }
        Object[] vals = this.getEnumValues();
        if (vals != null) {
            for (Object val : vals) {
                if (!((Enum)val).name().equals(name)) continue;
                return val;
            }
        }
        return null;
    }

    public Object[] getEnumValues() {
        if (this.kind != Kind.ENUM) {
            throw new RuntimeException("getEnumValues() can only be called on an enum");
        }
        try {
            return MappingUtil.getEnumValues(this.getRawType());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    long getNodeId() {
        return this.nodeId;
    }

    void addDeclaredFieldUnique(DOField field) {
        if (!this.containsDeclaredField(field.getName())) {
            this.getDeclaredFields().add(field);
        }
    }

    private boolean containsDeclaredField(String fieldName) {
        List<DOField> flds = this.getDeclaredFields();
        for (DOField f : flds) {
            if (!f.getName().equals(fieldName)) continue;
            return true;
        }
        return false;
    }

    void addInterfaceUnique(DOType intf) {
        if (!this.containsInterface(intf.getName())) {
            this.getInterfaces().add(intf);
        }
    }

    private boolean containsInterface(String fName) {
        List<DOType> ifs = this.getInterfaces();
        for (DOType intf : ifs) {
            if (!intf.getName().equals(fName)) continue;
            return true;
        }
        return false;
    }

    void setNodeId(long nodeId) {
        this.nodeId = nodeId;
    }

    public boolean isBuildIn() {
        return this.buildIn;
    }

    public String asString(String indent) {
        String indent2 = "".concat(indent).concat(indent);
        StringBuilder sb = new StringBuilder();
        sb.append(indent);
        if (this.kind != null) {
            sb.append((Object)this.kind);
            sb.append(' ');
        }
        sb.append(this.name);
        if (this.superType != null) {
            sb.append(" extends ");
            sb.append(this.superType.getName());
        }
        if (this.interfaces.size() > 0) {
            sb.append(" implements");
            for (DOType t : this.interfaces) {
                sb.append(' ');
                sb.append(t.getName());
            }
        }
        sb.append(" {");
        for (DOField f : this.declaredFields) {
            sb.append('\n');
            sb.append(f.asString(indent2));
        }
        sb.append(indent);
        sb.append('}');
        return sb.toString();
    }

    DomainModel getDomainModel() {
        return this.domainModel;
    }

    Class<?> getRawType() throws ClassNotFoundException {
        return this.domainModel.getClassForName(this.name);
    }

    public class DOEnumBuilder
    extends Builder {
        private DOEnumBuilder() {
        }

        public void setSuperType(DOType superType) {
            if (superType.getKind() != Kind.ENUM && !superType.getName().equals("java.lang.Enum")) {
                throw new RuntimeException("super type must be an Enum");
            }
            super.setSuperTypeInternal(superType);
        }

        public void setSuperTypeBuilder(DOEnumBuilder superTypeBuilder) {
            super.setSuperTypeInternal(superTypeBuilder.build());
        }

        public void addEnumValue(String name) {
            DOType.this.addDeclaredFieldUnique(new DOField(name, DOType.this.name, false, DOType.this));
        }
    }

    public class DOInterfaceBuilder
    extends Builder {
        private DOInterfaceBuilder() {
        }

        public void addInterface(DOType anInterface) {
            if (anInterface.getKind() != Kind.INTERFACE) {
                throw new RuntimeException("must be a kind of Interface");
            }
            DOType.this.addInterfaceUnique(anInterface);
        }

        public void addInterfaceBuilder(DOInterfaceBuilder builder) {
            DOType.this.addInterfaceUnique(builder.build());
        }
    }

    public class DOClassBuilder
    extends Builder {
        private DOClassBuilder() {
        }

        public void setAbstract() {
            DOType.this.kind = Kind.ABSTRACT_CLASS;
        }

        public void setSuperType(DOType superType) {
            if (superType.getKind() != Kind.CLASS && superType.getKind() != Kind.ABSTRACT_CLASS && !superType.getName().equals("java.lang.Object")) {
                throw new RuntimeException("super type must be a Class or an Abstract Class");
            }
            super.setSuperTypeInternal(superType);
        }

        public void setSuperTypeBuilder(DOClassBuilder superTypeBuilder) {
            super.setSuperTypeInternal(superTypeBuilder.build());
        }

        public void addInterface(DOType anInterface) {
            if (anInterface.getKind() != Kind.INTERFACE) {
                throw new RuntimeException("must be a kind of Interface");
            }
            DOType.this.addInterfaceUnique(anInterface);
        }

        public void addInterfaceBuilder(DOInterfaceBuilder builder) {
            DOType.this.addInterfaceUnique(builder.build());
        }

        public void addField(String name, String typeName) {
            DOType.this.addDeclaredFieldUnique(new DOField(name, typeName, false, DOType.this));
        }

        public void addListField(String name, String componentTypeName) {
            DOType.this.addDeclaredFieldUnique(new DOField(name, componentTypeName, true, DOType.this));
        }
    }

    public abstract class Builder {
        private Builder() {
        }

        void setKind(Kind k) {
            DOType.this.kind = k;
        }

        void setSuperTypeInternal(DOType superType) {
            DOType.this.superType = superType;
        }

        public DOType build() {
            return DOType.this;
        }
    }

    public static enum Kind {
        CLASS,
        ABSTRACT_CLASS,
        INTERFACE,
        ENUM;

    }
}

