/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.domain.genericmodel;

import iot.jcypher.domain.genericmodel.DOField;
import iot.jcypher.domain.genericmodel.DOType;
import iot.jcypher.domain.genericmodel.internal.InternalAccess;
import iot.jcypher.domain.internal.DomainAccess;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

public class DomainObject {
    private DOType domainObjectType;
    private Object rawObject;

    public DomainObject(DOType doType) {
        this(doType, true);
    }

    DomainObject(DOType doType, boolean toNursery) {
        if (doType == null) {
            throw new RuntimeException("a domain object must be constructed with a domain object type");
        }
        this.domainObjectType = doType;
        if (toNursery) {
            this.domainObjectType.getDomainModel().addNurseryObject(this.getRawObject(), this);
        }
    }

    public DOType getDomainObjectType() {
        return this.domainObjectType;
    }

    public void setFieldValue(String fieldName, Object value) {
        DOField field = this.domainObjectType.getFieldByName(fieldName);
        if (field == null) {
            throw new RuntimeException("field: " + fieldName + " not found in: " + this.domainObjectType.getName());
        }
        if (field.getComponentTypeName() != null) {
            throw new RuntimeException("field: " + fieldName + " is a list field, use list field accessors instead ");
        }
        Object val = value;
        if (value instanceof DomainObject) {
            val = ((DomainObject)value).getRawObject();
        }
        field.setValue(this.getRawObject(), val);
    }

    public void addListFieldValue(String fieldName, Object value) {
        Class<?> clazz;
        Object val = value;
        if (value instanceof DomainObject) {
            val = ((DomainObject)value).getRawObject();
        }
        Object lst = this.getFieldValue(fieldName, true);
        DOField fld = this.getDomainObjectType().getFieldByName(fieldName);
        String ctn = fld.getComponentTypeName();
        try {
            clazz = this.getDomainObjectType().getDomainModel().getClassForName(ctn);
            if (!clazz.isAssignableFrom(val.getClass())) {
                throw new RuntimeException("value must be of type or subtype of: [" + clazz.getName() + "]");
            }
            lst = this.tryInitListOrArray(lst, fld, clazz);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        if (lst instanceof List) {
            List list = (List)lst;
            list.add(val);
        } else if (lst != null && lst.getClass().isArray()) {
            int len = Array.getLength(lst);
            Object array = Array.newInstance(clazz, len + 1);
            for (int i = 0; i < len; ++i) {
                Array.set(array, i, Array.get(lst, i));
            }
            Array.set(array, len, val);
        } else {
            if (!this.getDomainObjectType().getFieldByName(fieldName).isListOrArray()) {
                throw new RuntimeException("field: [" + fieldName + "] is neither list nor array");
            }
            if (lst == null) {
                throw new RuntimeException("field: [" + fieldName + "] has not been initialized as list or array");
            }
        }
    }

    public void insertListFieldValue(String fieldName, int index, Object value) {
        Class<?> clazz;
        Object val = value;
        if (value instanceof DomainObject) {
            val = ((DomainObject)value).getRawObject();
        }
        Object lst = this.getFieldValue(fieldName, true);
        DOField fld = this.getDomainObjectType().getFieldByName(fieldName);
        String ctn = fld.getComponentTypeName();
        try {
            clazz = this.getDomainObjectType().getDomainModel().getClassForName(ctn);
            if (!clazz.isAssignableFrom(val.getClass())) {
                throw new RuntimeException("value must be of type or subtype of: [" + clazz.getName() + "]");
            }
            lst = this.tryInitListOrArray(lst, fld, clazz);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        if (lst instanceof List) {
            List list = (List)lst;
            list.add(index, val);
        } else if (lst != null && lst.getClass().isArray()) {
            int i;
            int len = Array.getLength(lst);
            Object array = Array.newInstance(clazz, len + 1);
            for (i = 0; i < index; ++i) {
                Array.set(array, i, Array.get(lst, i));
            }
            Array.set(array, index, val);
            for (i = index + 1; i < len + 1; ++i) {
                Array.set(array, i, Array.get(lst, i - 1));
            }
        } else {
            if (!this.getDomainObjectType().getFieldByName(fieldName).isListOrArray()) {
                throw new RuntimeException("field: [" + fieldName + "] is neither list nor array");
            }
            if (lst == null) {
                throw new RuntimeException("field: [" + fieldName + "] has not been initialized as list or array");
            }
        }
    }

    public Object getFieldValue(String fieldName) {
        return this.getFieldValue(fieldName, false);
    }

    Object getFieldValue(String fieldName, boolean internal) {
        DOField field = this.domainObjectType.getFieldByName(fieldName);
        if (field == null) {
            throw new RuntimeException("field: " + fieldName + " not found in: " + this.domainObjectType.getName());
        }
        if (!internal && field.getComponentTypeName() != null) {
            throw new RuntimeException("field: " + fieldName + " is a list field, use list field accessors instead ");
        }
        Object raw = field.getValue(this.getRawObject());
        DomainObject gdo = this.getForRawObject(raw);
        if (gdo != null) {
            return gdo;
        }
        return raw;
    }

    public Object getListFieldValue(String fieldName, int index) {
        Object ret = null;
        Object val = this.getFieldValue(fieldName, true);
        if (val instanceof List) {
            List list = (List)val;
            Object cval = list.get(index);
            DomainObject gdo = this.getForRawObject(cval);
            ret = gdo != null ? gdo : cval;
        } else if (val != null && val.getClass().isArray()) {
            Object aval = Array.get(val, index);
            DomainObject gdo = this.getForRawObject(aval);
            ret = gdo != null ? gdo : aval;
        } else {
            if (!this.getDomainObjectType().getFieldByName(fieldName).isListOrArray()) {
                throw new RuntimeException("field: [" + fieldName + "] is neither list nor array");
            }
            if (val == null) {
                throw new RuntimeException("list or array field: [" + fieldName + "] is null");
            }
        }
        return ret;
    }

    public int getIndexOfValue(String fieldName, Object value) {
        Object lst;
        int ret = -1;
        Object val = value;
        if (value instanceof DomainObject) {
            val = ((DomainObject)value).getRawObject();
        }
        if ((lst = this.getFieldValue(fieldName, true)) instanceof List) {
            List list = (List)lst;
            for (int i = 0; i < list.size(); ++i) {
                Object obj = list.get(i);
                if (!obj.equals(val)) continue;
                ret = i;
                break;
            }
        } else if (lst != null && lst.getClass().isArray()) {
            int len = Array.getLength(lst);
            for (int i = 0; i < len; ++i) {
                Object obj = Array.get(lst, i);
                if (!obj.equals(val)) continue;
                ret = i;
                break;
            }
        } else {
            if (!this.getDomainObjectType().getFieldByName(fieldName).isListOrArray()) {
                throw new RuntimeException("field: [" + fieldName + "] is neither list nor array");
            }
            if (lst == null) {
                throw new RuntimeException("list or array field: [" + fieldName + "] is null");
            }
        }
        return ret;
    }

    public void clearListField(String fieldName) {
        Object val = this.getFieldValue(fieldName, true);
        if (val instanceof List) {
            ((List)val).clear();
        } else if (val != null && val.getClass().isArray()) {
            DOField fld = this.getDomainObjectType().getFieldByName(fieldName);
            String ctn = fld.getComponentTypeName();
            try {
                Class<?> clazz = this.getDomainObjectType().getDomainModel().getClassForName(ctn);
                this.tryInitListOrArray(null, fld, clazz);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        } else {
            if (!this.getDomainObjectType().getFieldByName(fieldName).isListOrArray()) {
                throw new RuntimeException("field: [" + fieldName + "] is neither list nor array");
            }
            if (val == null) {
                throw new RuntimeException("list or array field: [" + fieldName + "] is null");
            }
        }
    }

    public void removeListFieldValue(String fieldName, int index) {
        Class<?> clazz;
        Object val = this.getFieldValue(fieldName, true);
        DOField fld = this.getDomainObjectType().getFieldByName(fieldName);
        String ctn = fld.getComponentTypeName();
        try {
            clazz = this.getDomainObjectType().getDomainModel().getClassForName(ctn);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        if (val instanceof List) {
            ((List)val).remove(index);
        } else if (val != null && val.getClass().isArray()) {
            int i;
            int len = Array.getLength(val);
            Object array = Array.newInstance(clazz, len - 1);
            for (i = 0; i < index; ++i) {
                Array.set(array, i, Array.get(val, i));
            }
            for (i = index; i < len - 1; ++i) {
                Array.set(array, i, Array.get(val, i - 1));
            }
        } else {
            if (!this.getDomainObjectType().getFieldByName(fieldName).isListOrArray()) {
                throw new RuntimeException("field: [" + fieldName + "] is neither list nor array");
            }
            if (val == null) {
                throw new RuntimeException("list or array field: [" + fieldName + "] is null");
            }
        }
    }

    public int getListFieldLength(String fieldName) {
        int ret = -1;
        Object val = this.getFieldValue(fieldName, true);
        if (val instanceof List) {
            ret = ((List)val).size();
        } else if (val != null && val.getClass().isArray()) {
            ret = Array.getLength(val);
        } else {
            if (!this.getDomainObjectType().getFieldByName(fieldName).isListOrArray()) {
                throw new RuntimeException("field: [" + fieldName + "] is neither list nor array");
            }
            if (val == null) {
                throw new RuntimeException("list or array field: [" + fieldName + "] is null");
            }
        }
        return ret;
    }

    private Object tryInitListOrArray(Object list, DOField fld, Class<?> componentType) throws ClassNotFoundException {
        Object ret = list;
        if (list == null && fld.isBuidInType()) {
            Class<?> lstClazz = this.getDomainObjectType().getDomainModel().getClassForName(fld.getTypeName());
            if (List.class.isAssignableFrom(lstClazz)) {
                ret = new ArrayList();
            } else if (lstClazz.isArray()) {
                ret = Array.newInstance(componentType, 0);
            }
            if (ret != null) {
                fld.setValue(this.getRawObject(), ret);
            }
        }
        return ret;
    }

    private DomainObject getForRawObject(Object raw) {
        DomainAccess da;
        DomainObject gdo = null;
        if (raw != null && (gdo = (da = InternalAccess.getDomainAccess(this.domainObjectType.getDomainModel())).getInternalDomainAccess().getGenericDomainObject(raw)) == null) {
            gdo = this.domainObjectType.getDomainModel().getNurseryObject(raw);
        }
        return gdo;
    }

    void setRawObject(Object rawObject) {
        this.rawObject = rawObject;
    }

    Object getRawObject() {
        if (this.rawObject == null) {
            try {
                this.rawObject = this.domainObjectType.getRawType().newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
        return this.rawObject;
    }
}

