/*
 * Decompiled with CFR 0.152.
 */
package iot.jcypher.domain.genericmodel.internal;

import iot.jcypher.domain.genericmodel.DOField;
import iot.jcypher.domain.genericmodel.DOType;
import iot.jcypher.domain.genericmodel.DomainObject;
import iot.jcypher.domain.genericmodel.InternalAccess;
import iot.jcypher.domain.genericmodel.internal.IDOVisitor;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DOWalker {
    private List<DomainObject> domainObjects;
    private IDOVisitor visitor;

    public DOWalker(DomainObject domainObject, IDOVisitor visitor) {
        ArrayList<DomainObject> dobjs = new ArrayList<DomainObject>();
        dobjs.add(domainObject);
        this.domainObjects = dobjs;
        this.visitor = visitor;
    }

    public DOWalker(List<DomainObject> dobjs, IDOVisitor visitor) {
        this.domainObjects = dobjs;
        this.visitor = visitor;
    }

    public void walkDOGraph() {
        this.visitor.startVisitDomainObjects(this.domainObjects);
        for (DomainObject dobj : this.domainObjects) {
            this.walkDO(dobj, null, 0);
        }
        this.visitor.endVisitDomainObjects(this.domainObjects);
    }

    private void walkDO(DomainObject dobj, Field theField, int depth) {
        boolean goOn = this.visitor.startVisitDomainObject(dobj, theField, depth);
        DOType dot = dobj.getDomainObjectType();
        List<DOField> fields = dot.getFields();
        for (DOField field : fields) {
            Object val = InternalAccess.getFieldValueInternal(dobj, field.getName());
            this.visitor.startVisitField(field, val, depth + 1);
            if (val instanceof DomainObject) {
                if (goOn) {
                    this.walkDO((DomainObject)val, new Field(field), depth + 2);
                }
            } else if (val instanceof List) {
                List list = (List)val;
                int len = list.size();
                for (int i = 0; i < len; ++i) {
                    Object cval = dobj.getListFieldValue(field.getName(), i);
                    if (!(cval instanceof DomainObject) || !goOn) continue;
                    this.walkDO((DomainObject)cval, new IndexedField(i, len, field), depth + 2);
                }
            } else if (val != null && val.getClass().isArray()) {
                int len = Array.getLength(val);
                for (int i = 0; i < len; ++i) {
                    Object aval = dobj.getListFieldValue(field.getName(), i);
                    if (!(aval instanceof DomainObject) || !goOn) continue;
                    this.walkDO((DomainObject)aval, new IndexedField(i, len, field), depth + 2);
                }
            } else if (val instanceof Map) {
                Map map = (Map)val;
                for (Map.Entry entry : map.entrySet()) {
                    if (!(entry.getValue() instanceof DomainObject) || !goOn) continue;
                    this.walkDO((DomainObject)entry.getValue(), new KeyedField(entry.getKey(), field), depth + 2);
                }
            }
            this.visitor.endVisitField(field, val, depth + 1);
        }
        this.visitor.endVisitDomainObject(dobj, theField, depth);
    }

    public class KeyedField
    extends Field {
        private Object key;

        private KeyedField(Object key, DOField field) {
            super(field);
            this.key = key;
        }

        public Object getKey() {
            return this.key;
        }
    }

    public class IndexedField
    extends Field {
        private int size;
        private int index;

        private IndexedField(int index, int size, DOField field) {
            super(field);
            this.index = index;
            this.size = size;
        }

        public int getIndex() {
            return this.index;
        }

        public int getSize() {
            return this.size;
        }
    }

    public class Field {
        private DOField field;

        private Field(DOField field) {
            this.field = field;
        }

        public DOField getField() {
            return this.field;
        }
    }
}

